/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.util;

public enum JavaVersion {
    JAVA5("Java 5", "1.5", "J2SE-1.5"),
    JAVA6("Java 6", "1.6", "JavaSE-1.6"),
    JAVA7("Java 7", "1.7", "JavaSE-1.7"),
    JAVA8("Java 8", "1.8", "JavaSE-1.8");

    private final String label;
    private final String qualifier;
    private final String bree;

    private JavaVersion(String label, String qualifier, String bree) {
        this.label = label;
        this.qualifier = qualifier;
        this.bree = bree;
    }

    public static JavaVersion fromQualifier(String qualifier) {
        JavaVersion[] javaVersionArray = JavaVersion.values();
        int n = javaVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaVersion version = javaVersionArray[n2];
            if (version.qualifier.equals(qualifier)) {
                return version;
            }
            ++n2;
        }
        return null;
    }

    public static JavaVersion fromBree(String bree) {
        JavaVersion[] javaVersionArray = JavaVersion.values();
        int n = javaVersionArray.length;
        int n2 = 0;
        while (n2 < n) {
            JavaVersion version = javaVersionArray[n2];
            if (version.bree.equals(bree)) {
                return version;
            }
            ++n2;
        }
        return null;
    }

    public String getLabel() {
        return this.label;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public String getBree() {
        return this.bree;
    }

    public boolean isAtLeast(JavaVersion other) {
        return this.ordinal() >= other.ordinal();
    }
}

