/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.animation.Interpolator;
import javafx.geometry.Insets;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Line;
import javafx.util.Duration;
import org.eclipse.fx.ui.controls.styledtext.internal.DebugMarker;
import org.eclipse.fx.ui.controls.styledtext.internal.LineHelper;
import org.eclipse.fx.ui.controls.styledtext.internal.NodeCachePane;
import org.eclipse.fx.ui.controls.styledtext.internal.ReuseCache;
import org.eclipse.fx.ui.controls.styledtext.internal.Segment;
import org.eclipse.fx.ui.controls.styledtext.internal.TextNode;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotation;
import org.eclipse.fx.ui.controls.styledtext.model.TextAnnotationPresenter;

public class LineNode
extends StackPane {
    int leftPadding = 0;
    static final boolean debugAnimation = Boolean.getBoolean("styledtext.debuganimation");
    private DebugMarker debugUpdateText;
    DebugMarker debugUpdateAnnotations;
    DebugMarker debugUpdateSelection;
    DebugMarker debugUpdateCaret;
    private HBox debugBox;
    int index;
    LineHelper lineHelper;
    private static final String CSS_CLASS_SOURCE_SEGMENT_CONTAINER = "source-segment-container";
    private static final String CSS_CLASS_SELECTION_MARKER = "selection-marker";
    private static final String CSS_CLASS_STYLED_TEXT_LINE = "styled-text-line";
    private static final String CSS_CLASS_CURRENT_LINE = "current-line";
    TextLayer textLayer = new TextLayer();
    private SelectionLayer selectionLayer = new SelectionLayer();
    private CaretLayer caretLayer = new CaretLayer();
    private AnnotationLayer annotationLayer = new AnnotationLayer();
    boolean currentLine = false;

    private int getLineIndex() {
        return this.index;
    }

    static TextNode createNode() {
        TextNode textNode = new TextNode("");
        return textNode;
    }

    static Animation createCaretAnimation(Node caret) {
        FadeTransition t = new FadeTransition(Duration.millis((double)500.0), caret);
        t.setInterpolator(new Interpolator(){

            protected double curve(double t) {
                if (t < 0.5) {
                    return 0.0;
                }
                return 1.0;
            }
        });
        t.setAutoReverse(true);
        t.setFromValue(1.0);
        t.setToValue(0.0);
        t.setCycleCount(-1);
        return t;
    }

    public LineNode() {
        this.getStyleClass().add((Object)CSS_CLASS_STYLED_TEXT_LINE);
        this.setPadding(new Insets(0.0, 0.0, 0.0, (double)this.leftPadding));
        this.getChildren().setAll((Object[])new Node[]{this.selectionLayer, this.textLayer, this.caretLayer, this.annotationLayer});
        if (debugAnimation) {
            this.debugUpdateAnnotations = new DebugMarker(Color.RED, 400L);
            this.debugUpdateText = new DebugMarker(Color.AQUAMARINE, 300L);
            this.debugUpdateSelection = new DebugMarker(Color.BLUE, 150L);
            this.debugUpdateCaret = new DebugMarker(Color.GRAY, 150L);
            this.debugUpdateAnnotations.setWidth(10.0);
            this.debugUpdateText.setWidth(10.0);
            this.debugUpdateSelection.setWidth(10.0);
            this.debugUpdateCaret.setWidth(10.0);
            this.debugBox = new HBox();
            this.debugBox.setManaged(false);
            this.debugBox.getChildren().addAll((Object[])new Node[]{this.debugUpdateAnnotations, this.debugUpdateSelection, this.debugUpdateCaret, this.debugUpdateText});
            this.getChildren().add((Object)this.debugBox);
        }
    }

    protected void layoutChildren() {
        super.layoutChildren();
        if (debugAnimation) {
            this.debugBox.resizeRelocate(0.0, 0.0, 40.0, this.getHeight());
            this.debugUpdateAnnotations.resize(this.getHeight(), this.getHeight());
            this.debugUpdateText.resize(this.getHeight(), this.getHeight());
            this.debugUpdateSelection.resize(this.getHeight(), this.getHeight());
            this.debugUpdateCaret.resize(this.getHeight(), this.getHeight());
        }
    }

    public void setLineHelper(LineHelper helper) {
        this.lineHelper = helper;
    }

    public void update(Set<TextAnnotationPresenter> presenters) {
        this.requestLayout();
        this.updateContent(this.lineHelper.getSegments(this.index));
        this.updateSelection(this.lineHelper.getSelection(this.index), this.lineHelper.isValidLineIndex(this.index + 1) ? this.lineHelper.getSelection(this.index + 1) : null);
        this.updateCaret(this.lineHelper.getCaret(this.index));
        this.updateAnnotations(this.lineHelper.getTextAnnotations(this.index), presenters);
    }

    public void updateSelection(Range<Integer> lineSelection, Range<Integer> nextLine) {
        if (lineSelection != null && lineSelection.isEmpty()) {
            this.selectionLayer.updateSelection(null, false);
        } else {
            this.selectionLayer.updateSelection(lineSelection, nextLine != null);
        }
    }

    public void updateCaret(int caret) {
        this.caretLayer.updateCaret(caret);
        this.updateCurrentLine(caret != -1);
    }

    public void updateCurrentLine(boolean current) {
        if (this.currentLine != current) {
            if (current) {
                this.getStyleClass().add((Object)CSS_CLASS_CURRENT_LINE);
            } else {
                this.getStyleClass().remove((Object)CSS_CLASS_CURRENT_LINE);
            }
            this.currentLine = current;
            this.requestLayout();
        }
    }

    public void updateContent(List<Segment> content) {
        boolean updated = this.textLayer.updateContent(content);
        if (updated && debugAnimation) {
            this.debugUpdateText.play();
        }
    }

    public void updateAnnotations(Set<TextAnnotation> annotations, Set<TextAnnotationPresenter> presenters) {
        this.annotationLayer.updateAnnoations(annotations, presenters);
    }

    public int getCaretIndexAtPoint(Point2D p) {
        return this.textLayer.getCaretIndexAtPoint(p);
    }

    public int getStartOffset() {
        return this.lineHelper.getOffset(this.index);
    }

    public int getEndOffset() {
        return this.lineHelper.getOffset(this.index) + this.lineHelper.getLength(this.index);
    }

    public double getCharLocation(int charOffset) {
        return this.textLayer.getCharLocation(charOffset);
    }

    public String toString() {
        return "LineNode(idx: " + this.getLineIndex() + ")@" + ((Object)((Object)this)).hashCode();
    }

    public int getLineLength() {
        return this.lineHelper.getLength(this.index);
    }

    public void release() {
        this.index = -1;
        this.caretLayer.hideCaret();
        this.selectionLayer.selection = null;
        this.selectionLayer.selectionMarker.resize(0.0, 0.0);
    }

    public void setIndex(int idx) {
        this.index = idx;
    }

    public class AnnotationLayer
    extends StackPane {
        private Set<TextAnnotation> currentAnnotations;
        private Set<TextAnnotationPresenter> currentPresenters;
        Map<TextAnnotationPresenter, AnnotationOverlay> overlays = new HashMap<TextAnnotationPresenter, AnnotationOverlay>();

        public void updateAnnoations(Set<TextAnnotation> annotations, Set<TextAnnotationPresenter> presenters) {
            if (this.currentAnnotations != null && this.currentAnnotations.equals(annotations) && this.currentPresenters != null && this.currentPresenters.equals(presenters)) {
                return;
            }
            Iterator<Map.Entry<TextAnnotationPresenter, AnnotationOverlay>> iterator = this.overlays.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<TextAnnotationPresenter, AnnotationOverlay> entry = iterator.next();
                if (presenters.contains(entry.getKey())) continue;
                this.getChildren().remove((Object)entry.getValue());
                iterator.remove();
            }
            for (TextAnnotationPresenter presenter : presenters) {
                Set<TextAnnotation> applicableAnnotations = annotations.stream().filter(presenter::isApplicable).collect(Collectors.toSet());
                AnnotationOverlay overlay = this.overlays.get(presenter);
                if (overlay == null) {
                    overlay = new AnnotationOverlay(presenter);
                    this.getChildren().add((Object)overlay);
                    this.overlays.put(presenter, overlay);
                }
                overlay.prepareNodes(applicableAnnotations);
                overlay.requestLayout();
            }
            this.requestLayout();
            if (debugAnimation) {
                LineNode.this.debugUpdateAnnotations.play();
            }
            this.currentAnnotations = annotations;
            this.currentPresenters = presenters;
        }

        protected void layoutChildren() {
            super.layoutChildren();
        }

        private class AnnotationOverlay
        extends NodeCachePane {
            private TextAnnotationPresenter presenter;
            private Map<TextAnnotation, Node> usedNodes;
            private Set<TextAnnotation> current;

            public AnnotationOverlay(TextAnnotationPresenter presenter) {
                super(presenter::createNode);
                this.usedNodes = new HashMap<TextAnnotation, Node>();
                this.current = new HashSet<TextAnnotation>();
                this.presenter = presenter;
                this.setOpacity(0.5);
            }

            private Node getNode(TextAnnotation a) {
                Node node = this.usedNodes.get(a);
                if (node == null) {
                    node = this.getNode();
                    this.usedNodes.put(a, node);
                }
                return node;
            }

            public void prepareNodes(Set<TextAnnotation> annotations) {
                boolean same = this.current.equals(annotations);
                if (same) {
                    return;
                }
                this.current = annotations;
                Iterator<Map.Entry<TextAnnotation, Node>> iterator = this.usedNodes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<TextAnnotation, Node> entry = iterator.next();
                    if (!annotations.contains(entry.getKey())) {
                        this.releaseNode(entry.getValue());
                        iterator.remove();
                        continue;
                    }
                    if (this.presenter.isVisible(entry.getKey())) continue;
                    this.releaseNode(entry.getValue());
                    iterator.remove();
                }
                for (TextAnnotation a : annotations) {
                    Node n = this.getNode(a);
                    this.presenter.updateNode(n, a);
                }
            }

            protected void layoutChildren() {
                for (Map.Entry<TextAnnotation, Node> entry : this.usedNodes.entrySet()) {
                    Range<Integer> range = entry.getKey().getRange();
                    double x = LineNode.this.getCharLocation((Integer)range.lowerEndpoint());
                    double width = LineNode.this.getCharLocation((Integer)range.upperEndpoint()) - x;
                    entry.getValue().resizeRelocate(x, 0.0, width, this.getHeight());
                }
            }
        }
    }

    public class CaretLayer
    extends Region {
        private int caretIndex = -1;
        private Line caret = new Line();
        private Animation caretAnimation;

        public CaretLayer() {
            this.caret.setVisible(false);
            this.caret.setStrokeWidth(2.0);
            this.caret.getStyleClass().add((Object)"text-caret");
            this.caret.setVisible(false);
            this.getChildren().add((Object)this.caret);
            this.caretAnimation = LineNode.createCaretAnimation((Node)this.caret);
            this.caret.visibleProperty().addListener((x, o, n) -> {
                if (n.booleanValue()) {
                    if (this.caretAnimation.getStatus() != Animation.Status.RUNNING) {
                        this.caretAnimation.playFromStart();
                    }
                } else {
                    this.caretAnimation.stop();
                }
            });
        }

        void hideCaret() {
            this.caret.setVisible(false);
        }

        private void showCaret() {
            this.caret.setVisible(true);
        }

        public void updateCaret(int index) {
            if (index != this.caretIndex) {
                if (index == -1) {
                    this.hideCaret();
                } else {
                    this.showCaret();
                }
                this.caretIndex = index;
                this.requestLayout();
                if (debugAnimation) {
                    LineNode.this.debugUpdateCaret.play();
                }
            }
        }

        public void layoutChildren() {
            double caretOffset = LineNode.this.getCharLocation(this.caretIndex);
            this.caret.setStartX(caretOffset);
            this.caret.setEndX(caretOffset);
            this.caret.setStartY(0.0);
            this.caret.setEndY(this.getHeight());
            this.caret.toFront();
        }
    }

    public class SelectionLayer
    extends Region {
        Region selectionMarker = new Region();
        Range<Integer> selection;
        private boolean continues;

        public SelectionLayer() {
            this.selectionMarker.getStyleClass().add((Object)LineNode.CSS_CLASS_SELECTION_MARKER);
            this.selectionMarker.setManaged(false);
            this.getChildren().setAll((Object[])new Node[]{this.selectionMarker});
        }

        private boolean isSelectionChange(Range<Integer> localSelection) {
            if (localSelection == null && this.selection == null) {
                return false;
            }
            return this.selection == null || !this.selection.equals(localSelection);
        }

        public void updateSelection(Range<Integer> localSelection, boolean continues) {
            this.continues = continues;
            if (this.isSelectionChange(localSelection)) {
                if (localSelection == null) {
                    this.selectionMarker.setVisible(false);
                } else {
                    this.selectionMarker.setVisible(true);
                }
                this.selection = localSelection;
                this.requestLayout();
                if (debugAnimation) {
                    LineNode.this.debugUpdateSelection.play();
                }
            }
        }

        protected void layoutChildren() {
            if (this.selection != null) {
                LineNode.this.textLayer.layout();
                double begin = LineNode.this.textLayer.getCharLocation((Integer)this.selection.lowerEndpoint());
                double end = LineNode.this.textLayer.getCharLocation((Integer)this.selection.upperEndpoint());
                if (((Integer)this.selection.upperEndpoint()).intValue() == LineNode.this.lineHelper.getLength(LineNode.this.index) && this.continues) {
                    end = this.getWidth();
                }
                this.selectionMarker.resizeRelocate(begin, 0.0, end - begin, this.getHeight());
            }
        }
    }

    public class TextLayer
    extends HBox {
        protected final ReuseCache<TextNode> cache;
        private List<Segment> currentContent = new ArrayList<Segment>();
        private List<TextNode> currentTextNodes = new ArrayList<TextNode>();

        public TextLayer() {
            this.getStyleClass().add((Object)LineNode.CSS_CLASS_SOURCE_SEGMENT_CONTAINER);
            this.setMinWidth(-1.0);
            this.cache = new ReuseCache<TextNode>(LineNode::createNode);
            this.cache.addOnActivate(node -> this.getChildren().add((Object)node));
            this.cache.addOnRelease(node -> this.getChildren().remove((Object)node));
        }

        public boolean updateContent(List<Segment> content) {
            if (this.currentContent.equals(content)) {
                return false;
            }
            for (TextNode c : this.currentTextNodes) {
                this.cache.releaseElement(c);
            }
            this.currentTextNodes.clear();
            for (Segment segment : content) {
                TextNode node = this.cache.getElement();
                node.updateText(segment.text);
                node.getStyleClass().setAll(segment.styleClasses);
                this.currentTextNodes.add(node);
            }
            if (content.isEmpty()) {
                TextNode node = this.cache.getElement();
                node.updateText("");
                this.currentTextNodes.add(node);
            }
            this.currentContent = content;
            return true;
        }

        public int getCaretIndexAtPoint(Point2D point) {
            Point2D scenePoint = this.localToScene(point);
            int offset = 0;
            for (TextNode t : this.currentTextNodes) {
                int idx;
                if (t.localToScene(t.getBoundsInLocal()).contains(scenePoint) && (idx = t.getCaretIndexAtPoint(t.sceneToLocal(scenePoint))) != -1) {
                    int result = idx + offset;
                    return result;
                }
                offset += t.getText().length();
            }
            return -1;
        }

        public double getCharLocation(int charOffset) {
            double result = 0.0;
            int startOffset = 0;
            for (TextNode t : this.currentTextNodes) {
                int len = t.getText().length();
                if (charOffset >= startOffset && charOffset <= startOffset + len) {
                    int textNodeOffset = charOffset - startOffset;
                    result = t.getCharLocation(textNodeOffset);
                    break;
                }
                if (charOffset > startOffset + len) {
                    result = t.getLayoutX() + t.getWidth();
                }
                startOffset += len;
            }
            return result;
        }

        protected void layoutChildren() {
            super.layoutChildren();
        }

        protected String getText() {
            StringBuilder b = new StringBuilder();
            for (TextNode t : this.currentTextNodes) {
                b.append(t.getText());
            }
            return b.toString();
        }
    }
}

