/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext.internal;

import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.scene.Node;
import org.eclipse.fx.ui.controls.styledtext.internal.VerticalLineFlow;
import org.eclipse.fx.ui.controls.styledtext.model.Annotation;
import org.eclipse.fx.ui.controls.styledtext.model.LineRulerAnnotationPresenter;

public class LineRuler
extends VerticalLineFlow<Integer, Annotation> {
    private LineRulerAnnotationPresenter.LayoutHint h;
    private DoubleProperty absoluteMinWidth = new SimpleDoubleProperty((Object)this, "absoluteMinWidth");
    private DoubleProperty yOffset = new SimpleDoubleProperty((Object)this, "yOffset");

    public DoubleProperty yOffsetProperty() {
        return this.yOffset;
    }

    public LineRuler(LineRulerAnnotationPresenter.LayoutHint h, Function<Integer, Set<Annotation>> converter, Predicate<Set<Annotation>> needsPresentation, Supplier<Node> nodeFactory, BiConsumer<Node, Set<Annotation>> nodePopulator) {
        super(converter, needsPresentation, nodeFactory, nodePopulator);
        this.h = h;
    }

    protected double computeMinWidth(double height) {
        return Math.max(this.absoluteMinWidth.get(), super.computePrefWidth(height));
    }

    public DoubleProperty absoluteMinWidthProperty() {
        return this.absoluteMinWidth;
    }

    @Override
    protected void layoutChildren() {
        this.activeNodes.entrySet().forEach(e -> {
            double w;
            double x = 0.0;
            double y = -this.yOffset.get() + (double)((Integer)e.getKey()).intValue() * this.lineHeightProperty().get();
            double width = this.getWidth();
            double height = this.getLineHeight();
            if (this.h == LineRulerAnnotationPresenter.LayoutHint.ALIGN_RIGHT) {
                ((Node)e.getValue()).autosize();
                w = ((Node)e.getValue()).getBoundsInLocal().getWidth();
                x = width - w;
                width = w;
            } else if (this.h == LineRulerAnnotationPresenter.LayoutHint.ALIGN_CENTER) {
                ((Node)e.getValue()).autosize();
                w = ((Node)e.getValue()).getBoundsInLocal().getWidth();
                x = width / 2.0 - w / 2.0;
                width = w;
            }
            double dy = height - ((Node)e.getValue()).getBoundsInLocal().getHeight();
            ((Node)e.getValue()).resizeRelocate(x, y + dy, width, height);
        });
    }
}

