/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.fx.core.OSGiUtil;
import org.eclipse.fx.core.Resource;
import org.eclipse.fx.core.URLResolver;
import org.eclipse.fx.core.function.ExExecutor;
import org.eclipse.fx.core.internal.JavaDSServiceProcessor;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.framework.FrameworkUtil;

public class Util {
    private static Boolean isOSGi;

    public static boolean isFX2() {
        return System.getProperty("javafx.version") != null && System.getProperty("javafx.version").startsWith("2");
    }

    public static boolean isFX9() {
        return System.getProperty("javafx.version") != null && System.getProperty("javafx.version").startsWith("9");
    }

    public static boolean isFX8() {
        return System.getProperty("javafx.version") != null && System.getProperty("javafx.version").startsWith("8");
    }

    public static @NonNull String notNull(@Nullable String value, @NonNull String defaultValue) {
        return value == null ? defaultValue : value;
    }

    public static boolean isOsgiEnv() {
        if (isOSGi == null) {
            isOSGi = Boolean.FALSE;
            try {
                Class.forName("org.osgi.framework.FrameworkUtil");
                if (FrameworkUtil.getBundle(Util.class) != null) {
                    isOSGi = Boolean.TRUE;
                }
            }
            catch (Throwable throwable) {}
        }
        return isOSGi;
    }

    private static <S> @Nullable S _lookupService(@Nullable Class<?> requestor, @NonNull Class<S> serviceClass) {
        List<@NonNull S> _lookupServiceList = Util._lookupServiceList(requestor, serviceClass);
        if (!_lookupServiceList.isEmpty()) {
            return _lookupServiceList.get(0);
        }
        return null;
    }

    private static <S> @NonNull List<@NonNull S> _lookupServiceList(@Nullable Class<?> requestor, @NonNull Class<S> serviceClass) {
        if (Util.isOsgiEnv()) {
            return OSGiUtil.lookupServiceList(requestor, serviceClass);
        }
        return JavaDSServiceProcessor.lookupServiceList(requestor, serviceClass);
    }

    public static <S> @Nullable S lookupService(@NonNull Class<?> requestor, @NonNull Class<S> serviceClass) {
        return Util._lookupService(requestor, serviceClass);
    }

    public static <S> @Nullable S lookupService(@NonNull Class<S> serviceClass) {
        return Util._lookupService(null, serviceClass);
    }

    public static <S> @NonNull Optional<S> getService(@NonNull Class<S> serviceClass) {
        @Nullable S v = Util._lookupService(null, serviceClass);
        if (v == null) {
            return Optional.empty();
        }
        return Optional.of(v);
    }

    public static <S> @NonNull Optional<S> getService(@NonNull Class<?> requestor, @NonNull Class<S> serviceClass) {
        @Nullable S v = Util._lookupService(requestor, serviceClass);
        if (v == null) {
            return Optional.empty();
        }
        return Optional.of(v);
    }

    public static <S> @NonNull List<@NonNull S> lookupServiceList(@NonNull Class<?> requestor, @NonNull Class<S> serviceClass) {
        return Util._lookupServiceList(requestor, serviceClass);
    }

    public static <S> @NonNull List<@NonNull S> lookupServiceList(@NonNull Class<S> serviceClass) {
        return Util._lookupServiceList(null, serviceClass);
    }

    public static String slurpFileContent(Path path) throws IOException {
        byte[] buf = new byte[(int)Files.size(path)];
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = Files.newInputStream(path, new OpenOption[0]);){
            in.read(buf);
            return new String(buf);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readToString(InputStream in, Charset charset) {
        return Util.readToString(in, 1024, charset);
    }

    public static String readToString(InputStream in, int bufferLength, Charset charset) {
        StringBuilder b = new StringBuilder();
        char[] buf = new char[bufferLength];
        InputStreamReader r = new InputStreamReader(in, charset);
        try {
            int l;
            while ((l = r.read(buf, 0, bufferLength)) != -1) {
                b.append(buf, 0, l);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return b.toString();
    }

    public static void copyToStream(InputStream sourceStream, OutputStream targetStream) throws IOException {
        int l;
        byte[] buf = new byte[1024];
        while ((l = sourceStream.read(buf)) != -1) {
            targetStream.write(buf, 0, l);
        }
    }

    public static @NonNull Path zipDirectory(@NonNull Path dir, @Nullable Path zipFile) throws IOException {
        Path target = zipFile;
        if (target == null) {
            target = Files.createTempFile("generated-zip", ".zip", new FileAttribute[0]);
        }
        Throwable throwable = null;
        Object var4_5 = null;
        try (ZipOutputStream out = new ZipOutputStream(Files.newOutputStream(target, new OpenOption[0]));){
            for (Path c : Files.list(dir).collect(Collectors.toList())) {
                if (c.equals(target)) continue;
                Util.addEntry(out, dir, c);
            }
            out.close();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return target;
    }

    private static void addEntry(ZipOutputStream out, Path rootPath, Path p) throws IOException {
        if (Files.isDirectory(p, new LinkOption[0])) {
            for (Path c : Files.list(p).collect(Collectors.toList())) {
                Util.addEntry(out, rootPath, c);
            }
        } else {
            ZipEntry e = new ZipEntry(rootPath.relativize(p).toString());
            out.putNextEntry(e);
            Throwable throwable = null;
            Object var5_8 = null;
            try (InputStream s = Files.newInputStream(p, new OpenOption[0]);){
                Util.copyToStream(s, out);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            out.closeEntry();
        }
    }

    public static boolean isMacOS() {
        return "Mac OS X".equals(System.getProperty("os.name"));
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public static double unsignedConstraintValue(double v, double min, double max) {
        double rv = v;
        if (min >= 0.0) {
            rv = Math.max(rv, min);
        }
        if (max >= 0.0) {
            rv = Math.min(rv, max);
        }
        return rv;
    }

    public static <T> T debugStderr(T data) {
        System.err.println(data);
        return data;
    }

    public static Optional<Resource<@NonNull Path>> getLocalPath(@NonNull URL url, boolean copyIfNeeded) {
        return Util.lookupServiceList(URLResolver.class).stream().filter(r -> r.test(url)).findFirst().map(r -> Optional.of(Resource.createResource(r.resolveToLocalPath(url)))).orElseGet(() -> copyIfNeeded ? ExExecutor.executeSupplier(() -> Util.copyToTempFile(url), "Unable to copy resource") : Optional.empty());
    }

    public static Optional<URL> getLocalURL(@NonNull URL url) {
        return Util.lookupServiceList(URLResolver.class).stream().filter(r -> r.test(url)).findFirst().map(r -> r.resolveToLocalURL(url));
    }

    private static Resource<@NonNull Path> copyToTempFile(@NonNull URL url) throws IOException {
        Path path = Files.createTempFile("tmp", Paths.get(url.getPath(), new String[0]).getFileName().toString(), new FileAttribute[0]);
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream stream = url.openStream();){
            Files.copy(stream, path, new CopyOption[0]);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        if (path == null) {
            return null;
        }
        return Resource.createTempResource(path);
    }

    public static URL createUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static Optional<URL> createUrl(String url, boolean log) {
        try {
            return Optional.of(new URL(url));
        }
        catch (Throwable e) {
            if (log) {
                LoggerCreator.createLogger(Util.class).error("Failed to create url from '" + url + "'", e);
            }
            return Optional.empty();
        }
    }

    public static String createRepeatedString(char c, int length) {
        char[] vals = new char[length];
        Arrays.fill(vals, ' ');
        return String.valueOf(vals);
    }
}

