/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.IGrammarAccess;
import org.eclipse.xtext.ParserRule;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.jvmmodel.ILogicalContainerProvider;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypePackage;

public class DefaultImportsConfiguration
implements IImportsConfiguration {
    @Inject
    private IJvmModelAssociations associations;
    @Inject
    private IGrammarAccess grammarAccess;
    @Inject
    private ILogicalContainerProvider logicalContainerProvider;

    @Override
    public XImportSection getImportSection(XtextResource resource) {
        EList contents = resource.getContents();
        if (!contents.isEmpty()) {
            TreeIterator i = ((EObject)contents.get(0)).eAllContents();
            while (i.hasNext()) {
                EObject next = (EObject)i.next();
                if (!(next instanceof XImportSection)) continue;
                return (XImportSection)next;
            }
        }
        return null;
    }

    @Override
    public Iterable<JvmDeclaredType> getLocallyDefinedTypes(XtextResource resource) {
        final ArrayList locallyDefinedTypes = Lists.newArrayList();
        TreeIterator i = resource.getAllContents();
        while (i.hasNext()) {
            EObject next = (EObject)i.next();
            if (next instanceof JvmDeclaredType) {
                JvmDeclaredType declaredType = (JvmDeclaredType)next;
                locallyDefinedTypes.add(declaredType);
                this.addInnerTypes(declaredType, (IAcceptor<? super JvmDeclaredType>)new IAcceptor<JvmDeclaredType>(){

                    public void accept(JvmDeclaredType t) {
                        locallyDefinedTypes.add(t);
                    }
                });
                i.prune();
            }
            if (!(next instanceof XExpression)) continue;
            i.prune();
        }
        return locallyDefinedTypes;
    }

    @Override
    public JvmDeclaredType getContextJvmDeclaredType(EObject model) {
        if (model != null) {
            JvmIdentifiableElement logicalContainer = this.logicalContainerProvider.getNearestLogicalContainer(model);
            if (logicalContainer != null) {
                return (JvmDeclaredType)EcoreUtil2.getContainerOfType((EObject)logicalContainer, JvmDeclaredType.class);
            }
            EObject currentElement = model;
            do {
                for (EObject jvmElement : this.associations.getJvmElements(currentElement)) {
                    if (!(jvmElement instanceof JvmDeclaredType)) continue;
                    return (JvmDeclaredType)jvmElement;
                }
            } while ((currentElement = currentElement.eContainer()) != null);
        }
        return null;
    }

    protected void addInnerTypes(JvmDeclaredType containerType, IAcceptor<? super JvmDeclaredType> result) {
        for (JvmMember member : containerType.getMembers()) {
            if (!(member instanceof JvmDeclaredType)) continue;
            result.accept((Object)((JvmDeclaredType)member));
            this.addInnerTypes((JvmDeclaredType)member, result);
        }
    }

    @Override
    public Set<String> getImplicitlyImportedPackages(XtextResource resource) {
        HashSet implicitlyImportedPackages = Sets.newHashSetWithExpectedSize((int)2);
        implicitlyImportedPackages.add("java.lang");
        return implicitlyImportedPackages;
    }

    @Override
    public int getImportSectionOffset(XtextResource resource) {
        INode node;
        List<EObject> pathToImportSection;
        if (resource.getParseResult() != null && resource.getParseResult().getRootNode() != null && (pathToImportSection = this.findPathToImportSection()) != null && (node = this.findPreviousNode(resource.getParseResult().getRootNode(), pathToImportSection)) != null) {
            return node.getTotalEndOffset();
        }
        return 0;
    }

    @Override
    public String getLegacyImportSyntax(XImportDeclaration importDeclaration) {
        List list = NodeModelUtils.findNodesForFeature((EObject)importDeclaration, (EStructuralFeature)XtypePackage.Literals.XIMPORT_DECLARATION__IMPORTED_TYPE);
        if (list.isEmpty()) {
            return null;
        }
        INode singleNode = (INode)list.get(0);
        if (singleNode.getText().indexOf(36) < 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (ILeafNode node : singleNode.getLeafNodes()) {
            if (node.isHidden()) continue;
            sb.append(node.getText().replace("^", ""));
        }
        return sb.toString();
    }

    protected INode findPreviousNode(ICompositeNode node, List<EObject> pathToImportSection) {
        if (pathToImportSection.isEmpty() || node.getGrammarElement() != pathToImportSection.get(0)) {
            return null;
        }
        INode currentNode = null;
        ICompositeNode currentParentNode = node;
        int currentDepth = 0;
        block0: while (currentDepth < pathToImportSection.size() - 1) {
            EObject expectedRuleCall = pathToImportSection.get(++currentDepth);
            AbstractRule ruleInGrammar = GrammarUtil.containingRule((EObject)expectedRuleCall);
            for (INode childNode : currentParentNode.getChildren()) {
                EObject elementInNode = childNode.getGrammarElement();
                if (elementInNode != null) {
                    TreeIterator i = ruleInGrammar.eAllContents();
                    while (i.hasNext()) {
                        EObject nextInGrammar = (EObject)i.next();
                        if (nextInGrammar == expectedRuleCall && childNode instanceof ICompositeNode) {
                            currentParentNode = (ICompositeNode)childNode;
                            continue block0;
                        }
                        if (nextInGrammar != elementInNode) continue;
                        break;
                    }
                }
                currentNode = childNode;
            }
        }
        return currentNode;
    }

    protected List<EObject> findPathToImportSection() {
        LinkedList pathToImportSection;
        EList rules = this.grammarAccess.getGrammar().getRules();
        if (!rules.isEmpty() && rules.get(0) instanceof ParserRule && this.internalFindPathToImportSection(pathToImportSection = Lists.newLinkedList(), new HashSet<ParserRule>(), (EObject)rules.get(0))) {
            return pathToImportSection;
        }
        return null;
    }

    protected boolean internalFindPathToImportSection(LinkedList<EObject> pathToImportSection, Set<ParserRule> seenRules, EObject ruleOrRuleCall) {
        ParserRule rule = null;
        EClassifier returnType = null;
        rule = ruleOrRuleCall instanceof ParserRule ? (ParserRule)ruleOrRuleCall : (ParserRule)((RuleCall)ruleOrRuleCall).getRule();
        if (seenRules.contains(rule)) {
            return false;
        }
        seenRules.add(rule);
        pathToImportSection.addLast(ruleOrRuleCall);
        returnType = rule.getType().getClassifier();
        if (returnType instanceof EClass && XtypePackage.Literals.XIMPORT_SECTION.isSuperTypeOf((EClass)returnType)) {
            return true;
        }
        for (RuleCall containedRuleCall : GrammarUtil.containedRuleCalls((EObject)rule)) {
            if (!(containedRuleCall.getRule() instanceof ParserRule) || !this.internalFindPathToImportSection(pathToImportSection, seenRules, (EObject)containedRuleCall)) continue;
            return true;
        }
        pathToImportSection.removeLast();
        return false;
    }

    @Override
    public String getPackageName(XtextResource xtextResource) {
        return null;
    }
}

