/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext;

import javafx.event.EventTarget;
import javafx.event.EventType;
import javafx.scene.input.InputEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;

public class VerifyEvent
extends InputEvent {
    public static final EventType<VerifyEvent> VERIFY = new EventType(InputEvent.ANY, "VERIFY");
    private static final long serialVersionUID = -4592943665566096149L;
    private String character;
    private String text;
    private KeyCode code;
    private boolean shiftDown;
    private boolean controlDown;
    private boolean altDown;
    private boolean metaDown;

    public VerifyEvent(Object source, EventTarget target, KeyEvent event) {
        super(source, target, VERIFY);
        boolean isKeyTyped = event.getEventType() == KeyEvent.KEY_TYPED;
        this.character = isKeyTyped ? event.getCharacter() : KeyEvent.CHAR_UNDEFINED;
        this.text = isKeyTyped ? "" : event.getText();
        this.code = isKeyTyped ? KeyCode.UNDEFINED : event.getCode();
        this.shiftDown = event.isShiftDown();
        this.controlDown = event.isControlDown();
        this.altDown = event.isAltDown();
        this.metaDown = event.isMetaDown();
    }

    public String getCharacter() {
        return this.character;
    }

    public String getText() {
        return this.text;
    }

    public KeyCode getCode() {
        return this.code;
    }

    public boolean isShiftDown() {
        return this.shiftDown;
    }

    public boolean isControlDown() {
        return this.controlDown;
    }

    public boolean isAltDown() {
        return this.altDown;
    }

    public boolean isMetaDown() {
        return this.metaDown;
    }
}

