/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.jdt;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.maven.cli.MavenCli;
import org.apache.maven.toolchain.io.DefaultToolchainsReader;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstall2;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.VMStandin;

public class LookupJDKToolchainsJob
extends Job {
    private final IVMInstallType standardType = JavaRuntime.getVMInstallType((String)"org.eclipse.jdt.internal.debug.ui.launcher.StandardVMType");

    public LookupJDKToolchainsJob() {
        super(LookupJDKToolchainsJob.class.getSimpleName());
    }

    protected IStatus run(IProgressMonitor monitor) {
        List<File> toolchainFiles = List.of(MavenCli.DEFAULT_GLOBAL_TOOLCHAINS_FILE, MavenCli.DEFAULT_USER_TOOLCHAINS_FILE);
        DefaultToolchainsReader reader = new DefaultToolchainsReader();
        for (File toolchainsFile : toolchainFiles) {
            if (!toolchainsFile.isFile() || !toolchainsFile.canRead()) continue;
            try {
                PersistedToolchains toolchains = reader.read(toolchainsFile, null);
                for (ToolchainModel toolchain : toolchains.getToolchains()) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    this.addToolchain(toolchain);
                }
            }
            catch (Exception e) {
                return Status.error((String)e.getMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    private Optional<File> getVMInstallation(ToolchainModel toolchain) {
        return Optional.ofNullable(toolchain).filter(t -> "jdk".equals(t.getType())).map(ToolchainModel::getConfiguration).filter(Xpp3Dom.class::isInstance).map(Xpp3Dom.class::cast).map(dom -> dom.getChild("jdkHome")).map(Xpp3Dom::getValue).map(File::new).filter(File::isDirectory);
    }

    private void addToolchain(ToolchainModel toolchain) {
        this.getVMInstallation(toolchain).filter(f -> this.standardType.validateInstallLocation(f).isOK()).ifPresent(candidate -> {
            if (Arrays.stream(this.standardType.getVMInstalls()).map(IVMInstall::getInstallLocation).filter(Objects::nonNull).noneMatch(install -> LookupJDKToolchainsJob.isSameCanonicalFile(candidate, install))) {
                IVMInstall2 newVM2;
                VMStandin workingCopy = new VMStandin(this.standardType, candidate.getAbsolutePath());
                workingCopy.setInstallLocation(candidate);
                Object name = candidate.getName();
                int i = 1;
                while (LookupJDKToolchainsJob.isDuplicateName((String)name)) {
                    name = candidate.getName() + "(" + i++ + ")";
                }
                workingCopy.setName((String)name);
                IVMInstall newVM = workingCopy.convertToRealVM();
                if (!(newVM instanceof IVMInstall2) || (newVM2 = (IVMInstall2)newVM).getJavaVersion() == null) {
                    this.standardType.disposeVMInstall(newVM.getId());
                }
            }
        });
    }

    private static boolean isDuplicateName(String name) {
        return Stream.of(JavaRuntime.getVMInstallTypes()).flatMap(vmType -> Arrays.stream(vmType.getVMInstalls())).map(IVMInstall::getName).anyMatch(name::equals);
    }

    private static boolean isSameCanonicalFile(File f1, File f2) {
        try {
            return Objects.equals(f1.getCanonicalFile(), f2.getCanonicalFile());
        }
        catch (IOException ex) {
            return false;
        }
    }
}

