/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.styledtext_ng.internal;

import com.google.common.collect.RangeSet;
import com.google.common.collect.TreeRangeSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import javafx.scene.layout.Region;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import org.eclipse.fx.core.geom.Size;
import org.eclipse.fx.core.text.TextUtil;
import org.eclipse.fx.ui.controls.Util;
import org.eclipse.fx.ui.controls.styledtext_ng.internal.BaseStyledLineRenderer;

public class SingleTextStyledLineRenderer
extends BaseStyledLineRenderer {
    private final LayoutPane node = new LayoutPane();
    private double minX = -1.0;
    private double maxX = -1.0;
    private int startCharIndex = -1;
    private int endCharIndex = -1;
    private double shiftX = 0.0;

    @Override
    public void setVisibleRange(double minX, double maxX) {
        this.minX = minX;
        this.maxX = maxX;
        this.rebuildText();
    }

    @Override
    public void clearStyles() {
    }

    @Override
    public Node getNode() {
        return this.node;
    }

    @Override
    protected void rebuildFill() {
        this.rebuildText();
    }

    @Override
    protected void rebuildFonts() {
        this.rebuildText();
    }

    @Override
    protected void rebuildText() {
        if (this.combinedAction) {
            this.flag |= 4;
            return;
        }
        this.node.requestLayout();
    }

    void refreshLayout() {
        if (this.flag == 0) {
            return;
        }
        this.flag = 0;
        RangeSet<Integer> normalFont = this.getNormalRange();
        RangeSet<Integer> boldRange = this.getBoldRange();
        RangeSet<Integer> italicRange = this.getItalicRange();
        RangeSet<Integer> boldItalicRange = this.getBoldItalicRange();
        HashMap<Paint, RangeSet<Integer>> normalTextColors = new HashMap<Paint, RangeSet<Integer>>();
        HashMap<Paint, RangeSet<Integer>> boldTextColors = new HashMap<Paint, RangeSet<Integer>>();
        HashMap<Paint, RangeSet<Integer>> italicTextColors = new HashMap<Paint, RangeSet<Integer>>();
        HashMap<Paint, RangeSet<Integer>> italicBoldTextColors = new HashMap<Paint, RangeSet<Integer>>();
        for (BaseStyledLineRenderer.PaintRange r : this.getPaintRanges()) {
            RangeSet set;
            if (!normalFont.subRangeSet(r.range).isEmpty()) {
                set = normalTextColors.computeIfAbsent(r.paint, p -> TreeRangeSet.create());
                set.addAll(normalFont.subRangeSet(r.range));
                continue;
            }
            if (!boldItalicRange.isEmpty() && !boldItalicRange.subRangeSet(r.range).isEmpty()) {
                set = italicBoldTextColors.computeIfAbsent(r.paint, p -> TreeRangeSet.create());
                set.addAll(boldItalicRange.subRangeSet(r.range));
                continue;
            }
            if (!italicRange.subRangeSet(r.range).isEmpty()) {
                set = italicTextColors.computeIfAbsent(r.paint, p -> TreeRangeSet.create());
                set.addAll(italicRange.subRangeSet(r.range));
                continue;
            }
            if (boldRange.subRangeSet(r.range).isEmpty()) continue;
            set = boldTextColors.computeIfAbsent(r.paint, p -> TreeRangeSet.create());
            set.addAll(boldRange.subRangeSet(r.range));
        }
        if (this.minX != -1.0 && this.maxX != -1.0) {
            DivisionResult v = SingleTextStyledLineRenderer.charInfo(this.minX, this.normal);
            this.startCharIndex = v.integer;
            this.shiftX = v.remainder * Util.getSize((Font)this.normal, (char)'A').width * -1.0;
            v = SingleTextStyledLineRenderer.charInfo(this.maxX, this.normal);
            this.endCharIndex = v.integer;
            this.node.setClip((Node)new Rectangle(0.0, 0.0, this.maxX - this.minX, Util.getSize((Font)this.normal, (char)'A').height));
        } else {
            this.startCharIndex = -1;
            this.endCharIndex = -1;
            this.shiftX = 0.0;
            if (this.node.getClip() != null) {
                this.node.setClip(null);
            }
        }
        ArrayList<Text> l = new ArrayList<Text>();
        l.addAll(SingleTextStyledLineRenderer.createTextNodes(this.startCharIndex, this.endCharIndex, normalTextColors, this.originalText, this.tabReplace, this.normal));
        l.addAll(SingleTextStyledLineRenderer.createTextNodes(this.startCharIndex, this.endCharIndex, boldTextColors, this.originalText, this.tabReplace, this.bold));
        l.addAll(SingleTextStyledLineRenderer.createTextNodes(this.startCharIndex, this.endCharIndex, italicTextColors, this.originalText, this.tabReplace, this.italic));
        l.addAll(SingleTextStyledLineRenderer.createTextNodes(this.startCharIndex, this.endCharIndex, italicBoldTextColors, this.originalText, this.tabReplace, this.boldItalic));
        this.node.getChildren().setAll(l);
    }

    private static List<Text> createTextNodes(int startCharIndex, int endCharIndex, Map<Paint, RangeSet<Integer>> textColorRanges, char[] text, char[] tabReplace, Font font) {
        ArrayList<Text> nodes = new ArrayList<Text>();
        for (Map.Entry<Paint, RangeSet<Integer>> e : textColorRanges.entrySet()) {
            char[] txt = TextUtil.replace((char[])text, (char)' ', (idx, ch) -> ch != 9 && !((RangeSet)e.getValue()).contains((Comparable)Integer.valueOf(idx)));
            char[] cs = TextUtil.replaceAll((char[])txt, (char)'\t', (char[])tabReplace);
            if (startCharIndex != -1 && endCharIndex != -1) {
                cs = Arrays.copyOfRange(cs, startCharIndex, Math.min(endCharIndex + 1, cs.length));
            }
            if (SingleTextStyledLineRenderer.isEmpty(cs)) continue;
            Text tNode = new Text(String.valueOf(cs));
            tNode.setFont(font);
            tNode.setFill(e.getKey());
            nodes.add(tNode);
        }
        return nodes;
    }

    private static boolean isEmpty(char[] cs) {
        int i = 0;
        while (i < cs.length) {
            if (cs[i] != ' ') {
                return false;
            }
            ++i;
        }
        return true;
    }

    static DivisionResult charInfo(double x, Font font) {
        Size w = Util.getSize(font, 'A');
        double charIdx = x / w.width;
        return new DivisionResult((int)charIdx, charIdx - (double)((int)charIdx));
    }

    static class DivisionResult {
        final int integer;
        final double remainder;

        public DivisionResult(int integer, double remainder) {
            this.integer = integer;
            this.remainder = remainder;
        }
    }

    class LayoutPane
    extends Region {
        LayoutPane() {
        }

        protected ObservableList<Node> getChildren() {
            return super.getChildren();
        }

        protected void layoutChildren() {
            SingleTextStyledLineRenderer.this.refreshLayout();
            this.getChildren().forEach(c -> c.resizeRelocate(SingleTextStyledLineRenderer.this.shiftX, 0.0, c.prefWidth(-1.0), c.prefHeight(-1.0)));
        }

        protected double computeMinHeight(double width) {
            return Util.getSize((Font)SingleTextStyledLineRenderer.this.normal, (char)' ').height;
        }

        protected double computePrefHeight(double width) {
            return super.computeMinHeight(width);
        }

        protected double computeMaxHeight(double width) {
            return super.computeMinHeight(width);
        }

        protected double computeMinWidth(double height) {
            return Util.getSize((Font)SingleTextStyledLineRenderer.this.normal, (char)' ').width * (double)SingleTextStyledLineRenderer.this.displayedText.length;
        }

        protected double computePrefWidth(double height) {
            return super.computeMinWidth(height);
        }

        protected double computeMaxWidth(double height) {
            return super.computeMinWidth(height);
        }
    }
}

