/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.renderers.fx.internal;

import java.util.Optional;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.eclipse.e4.ui.model.application.ui.basic.MStackElement;
import org.eclipse.fx.ui.controls.markers.AreaOverlay;
import org.eclipse.fx.ui.controls.markers.PositionMarker;
import org.eclipse.fx.ui.controls.markers.TabOutlineMarker;
import org.eclipse.fx.ui.workbench.renderers.base.services.DnDFeedbackService;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WDragTargetWidget;
import org.eclipse.fx.ui.workbench.renderers.base.widget.WLayoutedWidget;
import org.osgi.service.component.annotations.Component;

@Component
public class DefaultDnDFeedback
implements DnDFeedbackService {
    public DnDFeedbackService.MarkerFeedback showFeedback(DnDFeedbackService.DnDFeedbackData data) {
        Object widget = data.feedbackContainerElement.getWidget();
        if (widget instanceof WLayoutedWidget) {
            WLayoutedWidget l = (WLayoutedWidget)widget;
            Pane pane = (Pane)l.getStaticLayoutNode();
            if (data.dropType == WDragTargetWidget.BasicDropLocation.SPLIT_BOTTOM || data.dropType == WDragTargetWidget.BasicDropLocation.SPLIT_TOP || data.dropType == WDragTargetWidget.BasicDropLocation.SPLIT_RIGHT || data.dropType == WDragTargetWidget.BasicDropLocation.SPLIT_LEFT) {
                return DefaultDnDFeedback.handleSplit(pane, data);
            }
            if (data.reference instanceof MStackElement) {
                if (data.sourceElement.getParent() == data.feedbackContainerElement) {
                    return DefaultDnDFeedback.handleReorder(pane, data);
                }
                return DefaultDnDFeedback.handleMove(pane, data);
            }
        }
        return null;
    }

    private static DnDFeedbackService.MarkerFeedback handleSplit(Pane layoutNode, DnDFeedbackService.DnDFeedbackData data) {
        AreaOverlay overlay;
        Optional<Node> first = layoutNode.getChildren().stream().filter(n -> n instanceof AreaOverlay).findFirst();
        if (first.isPresent()) {
            overlay = (AreaOverlay)first.get();
        } else {
            overlay = new AreaOverlay(0.2);
            overlay.setManaged(false);
            overlay.setMouseTransparent(true);
            layoutNode.getChildren().add((Object)overlay);
            layoutNode.widthProperty().addListener(o -> overlay.resizeRelocate(0.0, 0.0, layoutNode.getWidth(), layoutNode.getHeight()));
            layoutNode.heightProperty().addListener(o -> overlay.resizeRelocate(0.0, 0.0, layoutNode.getWidth(), layoutNode.getHeight()));
            overlay.resizeRelocate(0.0, 0.0, layoutNode.getWidth(), layoutNode.getHeight());
        }
        overlay.setVisible(true);
        overlay.updateActiveArea(DefaultDnDFeedback.toArea((WDragTargetWidget.BasicDropLocation)data.dropType));
        return new DnDFeedbackService.MarkerFeedback(data){

            public void hide() {
                overlay.setVisible(false);
            }
        };
    }

    private static AreaOverlay.Area toArea(WDragTargetWidget.BasicDropLocation type) {
        switch (type) {
            case SPLIT_BOTTOM: {
                return AreaOverlay.Area.BOTTOM;
            }
            case SPLIT_LEFT: {
                return AreaOverlay.Area.LEFT;
            }
            case SPLIT_RIGHT: {
                return AreaOverlay.Area.RIGHT;
            }
            case SPLIT_TOP: {
                return AreaOverlay.Area.TOP;
            }
        }
        return AreaOverlay.Area.NONE;
    }

    private static DnDFeedbackService.MarkerFeedback handleReorder(Pane layoutNode, DnDFeedbackService.DnDFeedbackData data) {
        PositionMarker marker = null;
        for (Node n : layoutNode.getChildren()) {
            if (!(n instanceof PositionMarker)) continue;
            marker = (PositionMarker)n;
        }
        if (marker == null) {
            marker = new PositionMarker();
            marker.setManaged(false);
            layoutNode.getChildren().add((Object)marker);
        } else {
            layoutNode.getChildren().remove((Object)marker);
            layoutNode.getChildren().add((Object)marker);
            marker.setVisible(true);
        }
        double w = marker.getBoundsInLocal().getWidth();
        double h = marker.getBoundsInLocal().getHeight();
        double ratio = data.containerRegion.height / h;
        marker.setScaleX(ratio += 0.1);
        marker.setScaleY(ratio);
        double wDiff = w / 2.0;
        double hDiff = (h - h * ratio) / 2.0;
        if (data.dropType == WDragTargetWidget.BasicDropLocation.AFTER) {
            marker.relocate(data.containerRegion.x + data.containerRegion.width - wDiff, data.containerRegion.y - hDiff);
        } else {
            marker.relocate(data.containerRegion.x - wDiff, data.containerRegion.y - hDiff);
        }
        final PositionMarker fmarker = marker;
        return new DnDFeedbackService.MarkerFeedback(data){

            public void hide() {
                fmarker.setVisible(false);
            }
        };
    }

    private static DnDFeedbackService.MarkerFeedback handleMove(Pane layoutNode, DnDFeedbackService.DnDFeedbackData data) {
        TabOutlineMarker marker = null;
        for (Node n : layoutNode.getChildren()) {
            if (!(n instanceof TabOutlineMarker)) continue;
            marker = (TabOutlineMarker)n;
        }
        if (marker == null) {
            marker = new TabOutlineMarker(layoutNode.getBoundsInLocal(), (Bounds)new BoundingBox(data.containerRegion.x, data.containerRegion.y, data.containerRegion.width, data.containerRegion.height), data.dropType == WDragTargetWidget.BasicDropLocation.BEFORE);
            marker.setManaged(false);
            marker.setMouseTransparent(true);
            layoutNode.getChildren().add((Object)marker);
        } else {
            layoutNode.getChildren().remove(marker);
            layoutNode.getChildren().add((Object)marker);
            marker.updateBounds(layoutNode.getBoundsInLocal(), (Bounds)new BoundingBox(data.containerRegion.x, data.containerRegion.y, data.containerRegion.width, data.containerRegion.height), data.dropType == WDragTargetWidget.BasicDropLocation.BEFORE);
            marker.setVisible(true);
        }
        final TabOutlineMarker fmarker = marker;
        return new DnDFeedbackService.MarkerFeedback(data){

            public void hide() {
                fmarker.setVisible(false);
            }
        };
    }
}

