/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.ISourceLocator;
import org.eclipse.debug.internal.core.DebugCoreMessages;
import org.eclipse.debug.internal.core.LaunchManager;

public class Launch
extends PlatformObject
implements ILaunch,
IDisconnect,
ILaunchListener,
ILaunchConfigurationListener,
IDebugEventSetListener {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();
    private List<IDebugTarget> fTargets = new ArrayList<IDebugTarget>();
    private ILaunchConfiguration fConfiguration = null;
    private List<IProcess> fProcesses = new ArrayList<IProcess>();
    private ISourceLocator fLocator = null;
    private String fMode;
    private HashMap<String, String> fAttributes;
    private boolean fSuppressChange = true;

    public Launch(ILaunchConfiguration launchConfiguration, String mode, ISourceLocator locator) {
        this.fConfiguration = launchConfiguration;
        this.setSourceLocator(locator);
        this.fMode = mode;
        this.fSuppressChange = false;
        this.getLaunchManager().addLaunchListener(this);
        this.getLaunchManager().addLaunchConfigurationListener(this);
    }

    private void addEventListener() {
        DebugPlugin.getDefault().addDebugEventListener(this);
    }

    private void removeEventListener() {
        DebugPlugin.getDefault().removeDebugEventListener(this);
    }

    @Override
    public boolean canTerminate() {
        this.readLock.lock();
        try {
            for (IProcess process : this.getProcesses0()) {
                if (!process.canTerminate()) continue;
                return true;
            }
            for (IDebugTarget target : this.getDebugTargets0()) {
                if (!target.canTerminate() && !target.canDisconnect()) continue;
                return true;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    @Override
    public Object[] getChildren() {
        ArrayList<IDebugTarget> children;
        this.readLock.lock();
        try {
            children = new ArrayList<IDebugTarget>(this.getDebugTargets0());
            children.addAll(this.getProcesses0());
        }
        finally {
            this.readLock.unlock();
        }
        return children.toArray();
    }

    @Override
    public IDebugTarget getDebugTarget() {
        this.readLock.lock();
        try {
            if (!this.getDebugTargets0().isEmpty()) {
                IDebugTarget iDebugTarget = this.getDebugTargets0().get(0);
                return iDebugTarget;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    @Override
    public IProcess[] getProcesses() {
        this.readLock.lock();
        try {
            IProcess[] iProcessArray = this.getProcesses0().toArray(new IProcess[this.getProcesses0().size()]);
            return iProcessArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected List<IProcess> getProcesses0() {
        return this.fProcesses;
    }

    @Override
    public ISourceLocator getSourceLocator() {
        return this.fLocator;
    }

    @Override
    public void setSourceLocator(ISourceLocator sourceLocator) {
        this.fLocator = sourceLocator;
    }

    @Override
    public boolean isTerminated() {
        this.readLock.lock();
        try {
            if (this.getProcesses0().isEmpty() && this.getDebugTargets0().isEmpty()) {
                return false;
            }
            for (IProcess process : this.getProcesses0()) {
                if (process.isTerminated()) continue;
                return false;
            }
            for (IDebugTarget target : this.getDebugTargets0()) {
                if (target.isTerminated() || target.isDisconnected()) continue;
                return false;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return true;
    }

    @Override
    public void terminate() throws DebugException {
        MultiStatus status = new MultiStatus(DebugPlugin.getUniqueIdentifier(), 5012, DebugCoreMessages.Launch_terminate_failed, null);
        IDebugTarget[] targets = this.getDebugTargets();
        int i = 0;
        while (i < targets.length) {
            IDebugTarget target = targets[i];
            if (target != null) {
                if (target.canTerminate()) {
                    try {
                        target.terminate();
                    }
                    catch (DebugException e) {
                        status.merge(e.getStatus());
                    }
                } else if (target.canDisconnect()) {
                    try {
                        target.disconnect();
                    }
                    catch (DebugException de) {
                        status.merge(de.getStatus());
                    }
                }
            }
            ++i;
        }
        IProcess[] processes = this.getProcesses();
        int i2 = 0;
        while (i2 < processes.length) {
            IProcess process = processes[i2];
            if (process.canTerminate()) {
                try {
                    process.terminate();
                }
                catch (DebugException e) {
                    status.merge(e.getStatus());
                }
            }
            ++i2;
        }
        if (status.isOK()) {
            return;
        }
        IStatus[] children = status.getChildren();
        if (children.length == 1) {
            throw new DebugException(children[0]);
        }
        throw new DebugException((IStatus)status);
    }

    @Override
    public String getLaunchMode() {
        return this.fMode;
    }

    @Override
    public ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfiguration;
    }

    @Override
    public void setAttribute(String key, String value) {
        if (this.fAttributes == null) {
            this.fAttributes = new HashMap(5);
        }
        this.fAttributes.put(key, value);
    }

    @Override
    public String getAttribute(String key) {
        if (this.fAttributes == null) {
            return null;
        }
        return this.fAttributes.get(key);
    }

    @Override
    public IDebugTarget[] getDebugTargets() {
        this.readLock.lock();
        try {
            IDebugTarget[] iDebugTargetArray = this.fTargets.toArray(new IDebugTarget[this.fTargets.size()]);
            return iDebugTargetArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    protected List<IDebugTarget> getDebugTargets0() {
        return this.fTargets;
    }

    @Override
    public void addDebugTarget(IDebugTarget target) {
        if (target != null) {
            this.writeLock.lock();
            boolean changed = false;
            try {
                if (!this.getDebugTargets0().contains(target)) {
                    this.addEventListener();
                    changed = this.getDebugTargets0().add(target);
                }
            }
            finally {
                this.writeLock.unlock();
                if (changed) {
                    this.fireChanged();
                }
            }
        }
    }

    @Override
    public void removeDebugTarget(IDebugTarget target) {
        if (target != null) {
            this.writeLock.lock();
            boolean changed = false;
            try {
                changed = this.getDebugTargets0().remove(target);
            }
            finally {
                this.writeLock.unlock();
                if (changed) {
                    this.fireChanged();
                }
            }
        }
    }

    @Override
    public void addProcess(IProcess process) {
        if (process != null) {
            this.writeLock.lock();
            boolean changed = false;
            try {
                if (!this.getProcesses0().contains(process)) {
                    this.addEventListener();
                    changed = this.getProcesses0().add(process);
                }
            }
            finally {
                this.writeLock.unlock();
                if (changed) {
                    this.fireChanged();
                }
            }
        }
    }

    @Override
    public void removeProcess(IProcess process) {
        if (process != null) {
            this.writeLock.lock();
            boolean changed = false;
            try {
                changed = this.getProcesses0().remove(process);
            }
            finally {
                this.writeLock.unlock();
                if (changed) {
                    this.fireChanged();
                }
            }
        }
    }

    protected void addProcesses(IProcess[] processes) {
        if (processes != null) {
            int i = 0;
            while (i < processes.length) {
                this.addProcess(processes[i]);
                this.fireChanged();
                ++i;
            }
        }
    }

    protected void fireChanged() {
        if (!this.fSuppressChange) {
            ((LaunchManager)this.getLaunchManager()).fireUpdate(this, 2);
            ((LaunchManager)this.getLaunchManager()).fireUpdate(new ILaunch[]{this}, 2);
        }
    }

    protected void fireTerminate() {
        if (!this.fSuppressChange) {
            ((LaunchManager)this.getLaunchManager()).fireUpdate(this, 3);
            ((LaunchManager)this.getLaunchManager()).fireUpdate(new ILaunch[]{this}, 3);
        }
        this.removeEventListener();
    }

    @Override
    public boolean hasChildren() {
        return this.getProcesses0().size() > 0 || this.getDebugTargets0().size() > 0;
    }

    @Override
    public boolean canDisconnect() {
        this.readLock.lock();
        try {
            for (IProcess process : this.getProcesses0()) {
                if (!(process instanceof IDisconnect) || !((IDisconnect)((Object)process)).canDisconnect()) continue;
                return true;
            }
            for (IDebugTarget target : this.getDebugTargets0()) {
                if (!target.canDisconnect()) continue;
                return true;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return false;
    }

    @Override
    public void disconnect() throws DebugException {
        this.readLock.lock();
        try {
            for (IProcess process : this.getProcesses0()) {
                IDisconnect dis;
                if (!(process instanceof IDisconnect) || !(dis = (IDisconnect)((Object)process)).canDisconnect()) continue;
                dis.disconnect();
            }
            for (IDebugTarget target : this.getDebugTargets0()) {
                if (!target.canDisconnect()) continue;
                target.disconnect();
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean isDisconnected() {
        this.readLock.lock();
        try {
            for (IProcess process : this.getProcesses0()) {
                if (!(process instanceof IDisconnect) || ((IDisconnect)((Object)process)).isDisconnected()) continue;
                return false;
            }
            for (IDebugTarget target : this.getDebugTargets0()) {
                if (target.isDisconnected()) continue;
                return false;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return this.hasChildren();
    }

    @Override
    public void launchRemoved(ILaunch launch) {
        if (this.equals(launch)) {
            this.removeEventListener();
            this.getLaunchManager().removeLaunchListener(this);
            this.getLaunchManager().removeLaunchConfigurationListener(this);
        }
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    @Override
    public void launchAdded(ILaunch launch) {
    }

    @Override
    public void launchChanged(ILaunch launch) {
    }

    @Override
    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
        ILaunchConfiguration from = this.getLaunchManager().getMovedFrom(configuration);
        if (from != null && from.equals(this.getLaunchConfiguration())) {
            this.fConfiguration = configuration;
            this.fireChanged();
        }
    }

    @Override
    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
    }

    @Override
    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
        if (configuration.equals(this.getLaunchConfiguration()) && this.getLaunchManager().getMovedTo(configuration) == null) {
            this.fConfiguration = null;
            this.fireChanged();
        }
    }

    @Override
    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 8) {
                Object object = event.getSource();
                ILaunch launch = null;
                if (object instanceof IProcess) {
                    launch = ((IProcess)object).getLaunch();
                } else if (object instanceof IDebugTarget) {
                    launch = ((IDebugTarget)object).getLaunch();
                }
                if (this.equals(launch) && this.isTerminated()) {
                    this.fireTerminate();
                }
            }
            ++i;
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(ILaunch.class)) {
            return (T)this;
        }
        if (adapter.equals(ILaunchConfiguration.class)) {
            return (T)this.getLaunchConfiguration();
        }
        return (T)super.getAdapter(adapter);
    }
}

