/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.shell;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import org.apache.felix.gogo.shell.Builtin;
import org.apache.felix.gogo.shell.Converters;
import org.apache.felix.gogo.shell.Posix;
import org.apache.felix.gogo.shell.Procedural;
import org.apache.felix.gogo.shell.Shell;
import org.apache.felix.gogo.shell.Telnet;
import org.apache.felix.service.command.CommandProcessor;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Converter;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
Runnable {
    private BundleContext context;
    private ServiceTracker commandProcessorTracker;
    private Set<ServiceRegistration> regs = new HashSet<ServiceRegistration>();
    private CommandSession session;
    private Shell shell;
    private Thread thread;

    public void start(BundleContext ctxt) throws Exception {
        this.context = ctxt;
        this.commandProcessorTracker = this.processorTracker();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.thread != null) {
            this.thread.interrupt();
        }
        this.commandProcessorTracker.close();
        Iterator<ServiceRegistration> iterator = this.regs.iterator();
        while (iterator.hasNext()) {
            ServiceRegistration reg = iterator.next();
            reg.unregister();
            iterator.remove();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            Thread.sleep(100L);
            String args = this.context.getProperty("gosh.args");
            args = args == null ? "" : args;
            this.session.execute((CharSequence)("gosh --login " + args));
        }
        catch (Exception e) {
            Object loc = this.session.get(".location");
            if (null == loc || !loc.toString().contains(":")) {
                loc = "gogo";
            }
            System.err.println(loc + ": " + e.getClass().getSimpleName() + ": " + e.getMessage());
            e.printStackTrace();
        }
        finally {
            this.session.close();
        }
    }

    private void startShell(BundleContext context, CommandProcessor processor) {
        Hashtable<String, Object> dict = new Hashtable<String, Object>();
        ((Dictionary)dict).put("osgi.command.scope", "gogo");
        this.regs.add(context.registerService(Converter.class.getName(), (Object)new Converters(context), null));
        ((Dictionary)dict).put("osgi.command.function", Builtin.functions);
        this.regs.add(context.registerService(Builtin.class.getName(), (Object)new Builtin(), dict));
        ((Dictionary)dict).put("osgi.command.function", Procedural.functions);
        this.regs.add(context.registerService(Procedural.class.getName(), (Object)new Procedural(), dict));
        ((Dictionary)dict).put("osgi.command.function", Posix.functions);
        this.regs.add(context.registerService(Posix.class.getName(), (Object)new Posix(), dict));
        ((Dictionary)dict).put("osgi.command.function", Telnet.functions);
        this.regs.add(context.registerService(Telnet.class.getName(), (Object)new Telnet(processor), dict));
        this.shell = new Shell(context, processor);
        ((Dictionary)dict).put("osgi.command.function", Shell.functions);
        this.regs.add(context.registerService(Shell.class.getName(), (Object)this.shell, dict));
        this.session = processor.createSession(System.in, System.out, System.err);
        this.thread = new Thread((Runnable)this, "Gogo shell");
        this.thread.start();
    }

    private ServiceTracker processorTracker() {
        ServiceTracker t = new ServiceTracker(this.context, CommandProcessor.class.getName(), null){

            public Object addingService(ServiceReference reference) {
                CommandProcessor processor = (CommandProcessor)super.addingService(reference);
                Activator.this.startShell(this.context, processor);
                return processor;
            }

            public void removedService(ServiceReference reference, Object service) {
                if (Activator.this.thread != null) {
                    Activator.this.thread.interrupt();
                }
                super.removedService(reference, service);
            }
        };
        t.open();
        return t;
    }
}

