/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.access.impl;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;

public class InternalURIHelperConstants
implements URIHelperConstants {
    protected static final URI[] PRIMITIVE_URIS;
    static final String[] COMMON_CLASS_NAMES;
    static final String[][] COMMON_ANNOTATIONS;
    protected static final Map<String, URI> COMMON_URIS;
    protected static final Map<String, URI[]> COMMON_METHOD_URIS;
    protected static final Map<String, URI> COMMON_SIGNATURE_URIS;

    static {
        int i;
        PRIMITIVE_URIS = new URI[]{PRIMITIVES_URI.appendFragment("byte"), PRIMITIVES_URI.appendFragment("char"), PRIMITIVES_URI.appendFragment("double"), null, PRIMITIVES_URI.appendFragment("float"), null, null, PRIMITIVES_URI.appendFragment("int"), PRIMITIVES_URI.appendFragment("long"), null, null, null, null, null, null, null, null, PRIMITIVES_URI.appendFragment("short"), null, null, PRIMITIVES_URI.appendFragment("void"), null, null, null, PRIMITIVES_URI.appendFragment("boolean")};
        COMMON_CLASS_NAMES = new String[]{"java.lang.annotation.Annotation", "java.io.Serializable", "java.io.IOException", "java.lang.Boolean", "java.lang.Byte", "java.lang.Character", "java.lang.CharSequence", "java.lang.Class", "java.lang.Comparable", "java.lang.Double", "java.lang.Exception", "java.lang.Float", "java.lang.Integer", "java.lang.Iterable", "java.lang.Long", "java.lang.Math", "java.lang.Object", "java.lang.Short", "java.lang.String", "java.lang.StringBuilder", "java.lang.StringBuffer", "java.lang.Throwable", "java.lang.Void", "java.math.BigDecimal", "java.math.BigInteger", "java.util.ArrayList", "java.util.Collection", "java.util.HashMap", "java.util.HashSet", "java.util.Iterator", "java.util.List", "java.util.Map", "java.util.Set"};
        COMMON_ANNOTATIONS = new String[][]{{"com.google.common.annotations.Beta"}, {"com.google.common.annotations.GwtCompatible", "emulated", "serializable"}, {"com.google.common.annotations.GwtIncompatible", "value"}, {"java.lang.annotation.Documented"}, {"java.lang.annotation.Target", "value"}, {"java.lang.annotation.Retention", "value"}, {"java.lang.Deprecated"}, {"java.lang.Override"}, {"java.lang.SuppressWarnings", "value"}, {"org.eclipse.xtext.xbase.lib.Inline", "value", "imported", "statementExpression"}, {"org.eclipse.xtext.xbase.lib.Pure"}};
        COMMON_URIS = new HashMap<String, URI>();
        COMMON_METHOD_URIS = new HashMap<String, URI[]>();
        for (i = 0; i < COMMON_CLASS_NAMES.length; ++i) {
            String segment = COMMON_CLASS_NAMES[i];
            COMMON_URIS.put(segment, OBJECTS_URI.appendSegment(segment).appendFragment(segment));
        }
        for (i = 0; i < COMMON_ANNOTATIONS.length; ++i) {
            String[] annotations = COMMON_ANNOTATIONS[i];
            String annotation = annotations[0];
            COMMON_URIS.put(annotation, OBJECTS_URI.appendSegment(annotation).appendFragment(annotation));
            if (annotations.length <= 1) continue;
            URI[] methodURIs = new URI[annotations.length - 1];
            for (int j = 1; j < annotations.length; ++j) {
                String method = annotation + "." + annotations[j] + "()";
                methodURIs[j - 1] = OBJECTS_URI.appendSegment(annotation).appendFragment(method);
            }
            COMMON_METHOD_URIS.put(annotation, methodURIs);
        }
        COMMON_SIGNATURE_URIS = new HashMap<String, URI>();
        for (Map.Entry<String, URI> entry : COMMON_URIS.entrySet()) {
            COMMON_SIGNATURE_URIS.put("L" + entry.getKey() + ";", entry.getValue().trimFragment());
        }
        for (int i2 = 0; i2 < PRIMITIVE_URIS.length; ++i2) {
            URI uri = PRIMITIVE_URIS[i2];
            if (uri == null) continue;
            COMMON_SIGNATURE_URIS.put(uri.fragment(), PRIMITIVES_URI);
        }
    }
}

