/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.launching.AbstractRuntimeClasspathEntry;
import org.eclipse.jdt.internal.launching.LaunchingMessages;
import org.eclipse.jdt.internal.launching.RuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeContainerComparator;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DefaultProjectClasspathEntry
extends AbstractRuntimeClasspathEntry {
    public static final String TYPE_ID = "org.eclipse.jdt.launching.classpathentry.defaultClasspath";
    private boolean fExportedEntriesOnly = false;

    public DefaultProjectClasspathEntry() {
    }

    public DefaultProjectClasspathEntry(IJavaProject project) {
        this.setJavaProject(project);
    }

    @Override
    protected void buildMemento(Document document, Element memento) throws CoreException {
        memento.setAttribute("project", this.getJavaProject().getElementName());
        memento.setAttribute("exportedEntriesOnly", Boolean.toString(this.fExportedEntriesOnly));
    }

    @Override
    public void initializeFrom(Element memento) throws CoreException {
        String name = memento.getAttribute("project");
        if (name == null) {
            this.abort(LaunchingMessages.DefaultProjectClasspathEntry_3, null);
        }
        IJavaProject project = JavaCore.create((IProject)ResourcesPlugin.getWorkspace().getRoot().getProject(name));
        this.setJavaProject(project);
        name = memento.getAttribute("exportedEntriesOnly");
        if (name != null) {
            this.fExportedEntriesOnly = Boolean.valueOf(name);
        }
    }

    @Override
    public String getTypeId() {
        return TYPE_ID;
    }

    @Override
    public int getType() {
        return 5;
    }

    protected IProject getProject() {
        return this.getJavaProject().getProject();
    }

    @Override
    public String getLocation() {
        return this.getProject().getLocation().toOSString();
    }

    @Override
    public IPath getPath() {
        return this.getProject().getFullPath();
    }

    @Override
    public IResource getResource() {
        return this.getProject();
    }

    @Override
    public IRuntimeClasspathEntry[] getRuntimeClasspathEntries(ILaunchConfiguration configuration) throws CoreException {
        IClasspathEntry entry = JavaCore.newProjectEntry((IPath)this.getJavaProject().getProject().getFullPath());
        ArrayList<Object> classpathEntries = new ArrayList<Object>(5);
        ArrayList<IClasspathEntry> expanding = new ArrayList<IClasspathEntry>(5);
        this.expandProject(entry, classpathEntries, expanding);
        IRuntimeClasspathEntry[] runtimeEntries = new IRuntimeClasspathEntry[classpathEntries.size()];
        int i = 0;
        while (i < runtimeEntries.length) {
            Object e = classpathEntries.get(i);
            if (e instanceof IClasspathEntry) {
                IClasspathEntry cpe = (IClasspathEntry)e;
                runtimeEntries[i] = new RuntimeClasspathEntry(cpe);
            } else {
                runtimeEntries[i] = (IRuntimeClasspathEntry)e;
            }
            ++i;
        }
        ArrayList<IRuntimeClasspathEntry> ordered = new ArrayList<IRuntimeClasspathEntry>(runtimeEntries.length);
        int i2 = 0;
        while (i2 < runtimeEntries.length) {
            if (runtimeEntries[i2].getClasspathProperty() == 3) {
                ordered.add(runtimeEntries[i2]);
            }
            ++i2;
        }
        return ordered.toArray(new IRuntimeClasspathEntry[ordered.size()]);
    }

    private void expandProject(IClasspathEntry projectEntry, List<Object> expandedPath, List<IClasspathEntry> expanding) throws CoreException {
        expanding.add(projectEntry);
        IPath projectPath = projectEntry.getPath();
        IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(projectPath.lastSegment());
        if (res == null) {
            expandedPath.add(projectEntry);
            return;
        }
        IJavaProject project = (IJavaProject)JavaCore.create((IResource)res);
        if (project == null || !project.getProject().isOpen() || !project.exists()) {
            expandedPath.add(projectEntry);
            return;
        }
        IClasspathEntry[] buildPath = project.getRawClasspath();
        ArrayList<IClasspathEntry> unexpandedPath = new ArrayList<IClasspathEntry>(buildPath.length);
        boolean projectAdded = false;
        int i = 0;
        while (i < buildPath.length) {
            IClasspathEntry classpathEntry = buildPath[i];
            if (classpathEntry.getEntryKind() == 3) {
                if (!projectAdded) {
                    projectAdded = true;
                    unexpandedPath.add(projectEntry);
                }
            } else if (classpathEntry.isExported()) {
                unexpandedPath.add(classpathEntry);
            } else if (!this.isExportedEntriesOnly() || project.equals(this.getJavaProject())) {
                unexpandedPath.add(classpathEntry);
            }
            ++i;
        }
        block11: for (IClasspathEntry entry : unexpandedPath) {
            if (entry == projectEntry) {
                expandedPath.add(entry);
                continue;
            }
            switch (entry.getEntryKind()) {
                case 2: {
                    if (expanding.contains(entry)) continue block11;
                    this.expandProject(entry, expandedPath, expanding);
                    break;
                }
                case 5: {
                    IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)project);
                    int property = -1;
                    if (container == null) continue block11;
                    switch (container.getKind()) {
                        case 1: {
                            property = 3;
                            break;
                        }
                        case 3: {
                            property = 1;
                            break;
                        }
                        case 2: {
                            property = 2;
                        }
                    }
                    IRuntimeClasspathEntry r = JavaRuntime.newRuntimeContainerClasspathEntry(entry.getPath(), property, project);
                    boolean duplicate = false;
                    ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)r.getPath().segment(0));
                    int i2 = 0;
                    while (i2 < expandedPath.size()) {
                        IRuntimeClasspathEntry re;
                        Object o = expandedPath.get(i2);
                        if (o instanceof IRuntimeClasspathEntry && (re = (IRuntimeClasspathEntry)o).getType() == 4) {
                            if (container instanceof IRuntimeContainerComparator) {
                                duplicate = ((IRuntimeContainerComparator)container).isDuplicate(re.getPath());
                            } else {
                                ClasspathContainerInitializer initializer2 = JavaCore.getClasspathContainerInitializer((String)re.getPath().segment(0));
                                Object id1 = null;
                                Object id2 = null;
                                id1 = initializer == null ? r.getPath().segment(0) : initializer.getComparisonID(r.getPath(), project);
                                if (initializer2 == null) {
                                    id2 = re.getPath().segment(0);
                                } else {
                                    IJavaProject context = re.getJavaProject();
                                    if (context == null) {
                                        context = project;
                                    }
                                    id2 = initializer2.getComparisonID(re.getPath(), context);
                                }
                                duplicate = id1 == null ? id2 == null : id1.equals(id2);
                            }
                            if (duplicate) break;
                        }
                        ++i2;
                    }
                    if (duplicate) continue block11;
                    expandedPath.add(r);
                    break;
                }
                case 4: {
                    IRuntimeClasspathEntry r = JavaRuntime.newVariableRuntimeClasspathEntry(entry.getPath());
                    r.setSourceAttachmentPath(entry.getSourceAttachmentPath());
                    r.setSourceAttachmentRootPath(entry.getSourceAttachmentRootPath());
                    if (expandedPath.contains(r)) continue block11;
                    expandedPath.add(r);
                    break;
                }
                default: {
                    IRuntimeClasspathEntry r;
                    if (expandedPath.contains(entry)) continue block11;
                    if (entry.getEntryKind() != 3) {
                        IPackageFragmentRoot[] roots = project.findPackageFragmentRoots(entry);
                        int i3 = 0;
                        while (i3 < roots.length) {
                            IPackageFragmentRoot root = roots[i3];
                            r = JavaRuntime.newArchiveRuntimeClasspathEntry(root.getPath(), entry.getSourceAttachmentPath(), entry.getSourceAttachmentRootPath(), entry.getAccessRules(), entry.getExtraAttributes(), entry.isExported());
                            r.setSourceAttachmentPath(entry.getSourceAttachmentPath());
                            r.setSourceAttachmentRootPath(entry.getSourceAttachmentRootPath());
                            if (!expandedPath.contains(r)) {
                                expandedPath.add(r);
                            }
                            ++i3;
                        }
                        continue block11;
                    }
                    expandedPath.add(entry);
                }
            }
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    @Override
    public String getName() {
        if (this.isExportedEntriesOnly()) {
            return NLS.bind((String)LaunchingMessages.DefaultProjectClasspathEntry_2, (Object[])new String[]{this.getJavaProject().getElementName()});
        }
        return NLS.bind((String)LaunchingMessages.DefaultProjectClasspathEntry_4, (Object[])new String[]{this.getJavaProject().getElementName()});
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultProjectClasspathEntry) {
            DefaultProjectClasspathEntry entry = (DefaultProjectClasspathEntry)obj;
            return entry.getJavaProject().equals(this.getJavaProject()) && entry.isExportedEntriesOnly() == this.isExportedEntriesOnly();
        }
        return false;
    }

    public int hashCode() {
        return this.getJavaProject().hashCode();
    }

    public void setExportedEntriesOnly(boolean exportedOnly) {
        this.fExportedEntriesOnly = exportedOnly;
    }

    public boolean isExportedEntriesOnly() {
        return this.fExportedEntriesOnly | Platform.getPreferencesService().getBoolean("org.eclipse.jdt.launching", "org.eclipse.jdt.launching.only_include_exported_classpath_entries", false, null);
    }
}

