/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.tree;

import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.scene.control.TreeItem;
import org.eclipse.fx.ui.controls.tree.FilterableTreeItem;
import org.eclipse.fx.ui.controls.tree.TreeItemComparator;

public class SortableTreeItem<T>
extends FilterableTreeItem<T> {
    private SortedList<TreeItem<T>> sortedList;
    private ObjectProperty<TreeItemComparator<T>> comparator;

    public SortableTreeItem(T value) {
        super(value);
        this.parentProperty().addListener((o, oV, nV) -> {
            if (nV != null && nV instanceof SortableTreeItem && this.getComparator() == null) {
                this.comparatorProperty().bind(((SortableTreeItem)((Object)nV)).comparatorProperty());
            }
        });
    }

    @Override
    protected ObservableList<TreeItem<T>> getBackingList() {
        if (this.sortedList == null) {
            this.sortedList = new SortedList(super.getBackingList());
            this.sortedList.comparatorProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
                if (this.getComparator() == null) {
                    return null;
                }
                return (o1, o2) -> this.getComparator().compare((TreeItem<Object>)this, o1.getValue(), o2.getValue());
            }, (Observable[])new Observable[]{this.comparatorProperty()}));
        }
        return this.sortedList;
    }

    public final ObjectProperty<TreeItemComparator<T>> comparatorProperty() {
        if (this.comparator == null) {
            this.comparator = new SimpleObjectProperty();
        }
        return this.comparator;
    }

    public final TreeItemComparator<T> getComparator() {
        return (TreeItemComparator)this.comparatorProperty().get();
    }

    public final void setComparator(TreeItemComparator<T> comparator) {
        this.comparatorProperty().set(comparator);
    }
}

