/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.workbench.fx;

import com.sun.javafx.application.PlatformImpl;
import java.util.concurrent.CountDownLatch;
import javafx.application.Application;
import javafx.stage.Stage;
import org.eclipse.fx.core.SystemUtils;
import org.eclipse.fx.core.databinding.JFXRealm;
import org.eclipse.fx.ui.services.startup.StartupProgressTrackerService;
import org.eclipse.fx.ui.workbench.fx.DefaultJFXApp;
import org.eclipse.fx.ui.workbench.fx.E4Application;

public class E4MainThreadApplication
extends E4Application {
    static CountDownLatch STARTUP_LATCH = new CountDownLatch(1);
    static CountDownLatch SHUTDOWN_LATCH = new CountDownLatch(1);

    void super_launchE4JavaFxApplication() throws Exception {
        super.launchE4JavaFxApplication();
    }

    @Override
    protected void launchE4JavaFxApplication() throws Exception {
        if (SystemUtils.isMacOS()) {
            PlatformImpl.addListener((PlatformImpl.FinishListener)new PlatformImpl.FinishListener(){

                public void idle(boolean implicitExit) {
                    E4MainThreadApplication.this.jfxStop();
                    PlatformImpl.removeListener((PlatformImpl.FinishListener)this);
                    SHUTDOWN_LATCH.countDown();
                }

                public void exitCalled() {
                }
            });
            this.updateStartupState((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.JAVAFX_INITIALIZED_LAUNCHER_THREAD);
            PlatformImpl.startup(() -> {
                try {
                    JFXRealm.createDefault();
                    DefaultJFXApp.setProductApplicationName();
                    this.jfxStart(this.getApplicationContext(), null, null);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            });
            SHUTDOWN_LATCH.await();
        } else {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        E4MainThreadApplication.this.super_launchE4JavaFxApplication();
                    }
                    catch (Exception e) {
                        SHUTDOWN_LATCH.countDown();
                        e.printStackTrace();
                    }
                }
            };
            t.start();
            STARTUP_LATCH.await();
            this.updateStartupState((StartupProgressTrackerService.ProgressState)StartupProgressTrackerService.DefaultProgressState.JAVAFX_INITIALIZED_LAUNCHER_THREAD);
            SHUTDOWN_LATCH.await();
        }
    }

    @Override
    protected Class<? extends Application> getJfxApplicationClass() {
        return ExtendedE4Application.class;
    }

    public static class ExtendedE4Application
    extends DefaultJFXApp {
        @Override
        public void start(Stage primaryStage) throws Exception {
            STARTUP_LATCH.countDown();
            super.start(primaryStage);
        }

        @Override
        public void stop() throws Exception {
            super.stop();
            SHUTDOWN_LATCH.countDown();
        }
    }
}

