/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.util;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletContext;
import org.osgi.framework.ServiceReference;

public class ServiceProperties {
    public static boolean parseBoolean(ServiceReference<?> serviceReference, String property) {
        Object value = serviceReference.getProperty(property);
        if (Boolean.class.isInstance(value)) {
            return (Boolean)value;
        }
        if (String.class.isInstance(value)) {
            return Boolean.valueOf((String)value);
        }
        return false;
    }

    public static Map<String, String> parseInitParams(ServiceReference<?> serviceReference, String prefix, ServletContext parentContext) {
        HashMap<String, String> initParams = new HashMap<String, String>();
        if (parentContext != null) {
            Enumeration initParamNames = parentContext.getInitParameterNames();
            while (initParamNames.hasMoreElements()) {
                String key = (String)initParamNames.nextElement();
                initParams.put(key, parentContext.getInitParameter(key));
            }
        }
        String[] stringArray = serviceReference.getPropertyKeys();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (key.startsWith(prefix)) {
                initParams.put(key.substring(prefix.length()), String.valueOf(serviceReference.getProperty(key)));
            }
            ++n2;
        }
        return Collections.unmodifiableMap(initParams);
    }

    public static Map<String, String> parseInitParams(ServiceReference<?> serviceReference, String prefix) {
        return ServiceProperties.parseInitParams(serviceReference, prefix, null);
    }

    public static String parseName(Object property, Object object) {
        if (property == null) {
            return object.getClass().getName();
        }
        return String.valueOf(property);
    }
}

