/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.generator;

import com.google.inject.Injector;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.XtextVersion;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xtext.generator.IGuiceAwareGeneratorComponent;
import org.eclipse.xtext.xtext.generator.model.TypeReference;
import org.eclipse.xtext.xtext.generator.model.annotations.IClassAnnotation;

public class CodeConfig
implements IGuiceAwareGeneratorComponent {
    private static final String FILE_HEADER_VAR_TIME = "${time}";
    private static final String FILE_HEADER_VAR_DATE = "${date}";
    private static final String FILE_HEADER_VAR_YEAR = "${year}";
    private static final String FILE_HEADER_VAR_USER = "${user}";
    private static final String FILE_HEADER_VAR_VERSION = "${version}";
    @Accessors
    private String encoding = Charset.defaultCharset().name();
    @Accessors
    private String lineDelimiter = Strings.newLine();
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private String fileHeader;
    private String fileHeaderTemplate = "/*\n * generated by Xtext\n */";
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private final List<IClassAnnotation> classAnnotations = CollectionLiterals.newArrayList();
    @Accessors
    private boolean preferXtendStubs = true;
    @Accessors(value={AccessorType.PUBLIC_GETTER})
    private XtextVersion xtextVersion;

    public void setFileHeader(String fileHeaderTemplate) {
        this.fileHeaderTemplate = fileHeaderTemplate;
    }

    public void addClassAnnotation(IClassAnnotation annotation) {
        this.classAnnotations.add(annotation);
    }

    @Override
    public void initialize(Injector injector) {
        String fileHeader;
        injector.injectMembers((Object)this);
        this.xtextVersion = XtextVersion.getCurrent();
        if (this.lineDelimiter == null) {
            this.lineDelimiter = "\n";
        }
        if ((fileHeader = this.fileHeaderTemplate) != null) {
            boolean _contains_4;
            String user;
            boolean _contains_3;
            boolean _contains_2;
            boolean _contains_1;
            boolean _contains = fileHeader.contains(FILE_HEADER_VAR_TIME);
            if (_contains) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
                Date _date = new Date();
                String time = dateFormat.format(_date);
                fileHeader = fileHeader.replace(FILE_HEADER_VAR_TIME, time);
            }
            if (_contains_1 = fileHeader.contains(FILE_HEADER_VAR_DATE)) {
                SimpleDateFormat dateFormat_1 = new SimpleDateFormat("MMM d, yyyy");
                Date _date_1 = new Date();
                String date = dateFormat_1.format(_date_1);
                fileHeader = fileHeader.replace(FILE_HEADER_VAR_DATE, date);
            }
            if (_contains_2 = fileHeader.contains(FILE_HEADER_VAR_YEAR)) {
                SimpleDateFormat dateFormat_2 = new SimpleDateFormat("yyyy");
                Date _date_2 = new Date();
                String year = dateFormat_2.format(_date_2);
                fileHeader = fileHeader.replace(FILE_HEADER_VAR_YEAR, year);
            }
            if ((_contains_3 = fileHeader.contains(FILE_HEADER_VAR_USER)) && (user = System.getProperty("user.name")) != null) {
                fileHeader = fileHeader.replace(FILE_HEADER_VAR_USER, user);
            }
            if (_contains_4 = fileHeader.contains(FILE_HEADER_VAR_VERSION)) {
                fileHeader = fileHeader.replace(FILE_HEADER_VAR_VERSION, this.xtextVersion.toString());
            }
        }
        this.fileHeader = fileHeader;
    }

    public String getClassAnnotationsAsString() {
        boolean _isEmpty = this.classAnnotations.isEmpty();
        if (_isEmpty) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IClassAnnotation annotation : this.classAnnotations) {
            stringBuilder.append(annotation.toString()).append(Strings.newLine());
        }
        return stringBuilder.toString();
    }

    public String getAnnotationImportsAsString() {
        boolean _isEmpty = this.classAnnotations.isEmpty();
        if (_isEmpty) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IClassAnnotation annotation : this.classAnnotations) {
            TypeReference importString = annotation.getAnnotationImport();
            if (importString == null) continue;
            stringBuilder.append("import ").append(importString).append(";").append(Strings.newLine());
        }
        return stringBuilder.toString();
    }

    @Pure
    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    @Pure
    public String getLineDelimiter() {
        return this.lineDelimiter;
    }

    public void setLineDelimiter(String lineDelimiter) {
        this.lineDelimiter = lineDelimiter;
    }

    @Pure
    public String getFileHeader() {
        return this.fileHeader;
    }

    @Pure
    public List<IClassAnnotation> getClassAnnotations() {
        return this.classAnnotations;
    }

    @Pure
    public boolean isPreferXtendStubs() {
        return this.preferXtendStubs;
    }

    public void setPreferXtendStubs(boolean preferXtendStubs) {
        this.preferXtendStubs = preferXtendStubs;
    }

    @Pure
    public XtextVersion getXtextVersion() {
        return this.xtextVersion;
    }
}

