/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.m2e.core.internal.lifecyclemapping.MappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingFilter;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.PluginExecutionMetadata;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class MojoExecutionFilter
implements Predicate<PluginExecutionMetadata> {
    private List<LifecycleMappingFilter> filters;

    public MojoExecutionFilter(List<MappingMetadataSource> metadataSources, MojoExecutionKey executionKey) {
        this.filters = metadataSources.stream().flatMap(s -> s.getFilters().stream()).filter(filter -> filter.getPluginExecutions().stream().anyMatch(pluginFilter -> pluginFilter.match(executionKey))).collect(Collectors.toList());
    }

    @Override
    public boolean test(PluginExecutionMetadata metadata) {
        return Optional.ofNullable(metadata.getSource()).map(LifecycleMappingMetadataSource::getSource).filter(Bundle.class::isInstance).map(Bundle.class::cast).filter(bundle -> this.filters.stream().anyMatch(filter -> {
            Version version;
            return filter.getSymbolicName().equals(bundle.getSymbolicName()) && filter.matches(String.valueOf((version = bundle.getVersion()).getMajor()) + "." + version.getMinor() + "." + version.getMicro());
        })).isPresent();
    }
}

