/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ui.controls.image;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;

public class AdornedGraphicNode
extends AnchorPane {
    private final List<Adornment> adornments;

    public AdornedGraphicNode(@NonNull Node adornedGraphic, Adornment ... adornments) {
        this(adornedGraphic, Arrays.asList(adornments));
    }

    public AdornedGraphicNode(@NonNull Node adornedGraphic, List<@NonNull Adornment> adornments) {
        this.adornments = new ArrayList<Adornment>(adornments);
        this.getStyleClass().setAll((Object[])new String[]{"adorned-gaphic-node"});
        this.getChildren().add((Object)adornedGraphic);
        this.getChildren().addAll((Collection)adornments.stream().map(a -> a.getGraphic()).filter(g -> g != null).map(g -> {
            if (g != null) {
                g.setManaged(false);
            }
            return g;
        }).collect(Collectors.toList()));
    }

    protected void layoutChildren() {
        Node graphicsNode;
        super.layoutChildren();
        List collect = this.adornments.stream().filter(ad -> ad.getLocation() == Location.LEFT_TOP).map(ad -> ad.getGraphic()).filter(n -> n != null).collect(Collectors.toList());
        if (collect != null && !collect.isEmpty()) {
            if (collect.size() == 1) {
                graphicsNode = (Node)collect.get(0);
                graphicsNode.autosize();
                graphicsNode.relocate(0.0, 0.0);
            } else {
                double start = 0.0;
                for (Node n2 : collect) {
                    n2.autosize();
                    n2.relocate(start, 0.0);
                    start += n2.prefWidth(-1.0);
                }
            }
        }
        if ((collect = this.adornments.stream().filter(ad -> ad.getLocation() == Location.RIGHT_TOP).map(ad -> ad.getGraphic()).filter(n -> n != null).collect(Collectors.toList())) != null && !collect.isEmpty()) {
            if (collect.size() == 1) {
                graphicsNode = (Node)collect.get(0);
                graphicsNode.autosize();
                graphicsNode.relocate(this.getWidth() - graphicsNode.prefWidth(-1.0), 0.0);
            } else {
                double start = 0.0;
                for (Node n2 : collect) {
                    n2.autosize();
                    n2.relocate(this.getWidth() - n2.prefWidth(-1.0) - start, 0.0);
                    start += n2.prefWidth(-1.0);
                }
            }
        }
        if ((collect = this.adornments.stream().filter(ad -> ad.getLocation() == Location.LEFT_BOTTOM).map(ad -> ad.getGraphic()).filter(n -> n != null).collect(Collectors.toList())) != null && !collect.isEmpty()) {
            if (collect.size() == 1) {
                Node graphicsNode2 = (Node)collect.get(0);
                graphicsNode2.autosize();
                graphicsNode2.relocate(0.0, this.getHeight() - graphicsNode2.prefHeight(-1.0));
            } else {
                double start = 0.0;
                for (Node n2 : collect) {
                    n2.autosize();
                    n2.relocate(start, this.getHeight() - n2.prefHeight(-1.0));
                    start += n2.prefWidth(-1.0);
                }
            }
        }
        if ((collect = this.adornments.stream().filter(ad -> ad.getLocation() == Location.RIGHT_BOTTOM).map(ad -> ad.getGraphic()).filter(n -> n != null).collect(Collectors.toList())) != null && !collect.isEmpty()) {
            if (collect.size() == 1) {
                Node graphicsNode3 = (Node)collect.get(0);
                graphicsNode3.autosize();
                graphicsNode3.relocate(this.getWidth() - graphicsNode3.prefWidth(-1.0), this.getHeight() - graphicsNode3.prefHeight(-1.0));
            } else {
                double start = 0.0;
                for (Node n2 : collect) {
                    n2.autosize();
                    n2.relocate(this.getWidth() - n2.prefWidth(-1.0) - start, this.getHeight() - n2.prefHeight(-1.0));
                    start += n2.prefWidth(-1.0);
                }
            }
        }
    }

    public static interface Adornment {
        public @NonNull Location getLocation();

        public @Nullable Node getGraphic();

        public static Adornment create(final @NonNull Location location, final @NonNull Node graphic) {
            return new Adornment(){

                @Override
                public @NonNull Location getLocation() {
                    return location;
                }

                @Override
                public @Nullable Node getGraphic() {
                    return graphic;
                }
            };
        }
    }

    public static enum Location {
        LEFT_TOP,
        LEFT_BOTTOM,
        RIGHT_TOP,
        RIGHT_BOTTOM;

    }
}

