/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.converter;

import java.io.InputStream;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.fx.formats.svg.converter.FXMLConverter;
import org.eclipse.fx.formats.svg.handler.XMLLoader;
import org.eclipse.fx.formats.svg.svg.SvgSvgElement;
import org.eclipse.fx.ide.converter.AbstractConverterHandler;
import org.eclipse.jdt.annotation.NonNull;

public class ConvertSVGHandler
extends AbstractConverterHandler {
    @Override
    protected String convert(@NonNull IFile outFile, @NonNull IFile file) throws ExecutionException {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (InputStream contents = file.getContents();){
                if (contents == null) {
                    throw new ExecutionException("Could not retrieve file contents");
                }
                SvgSvgElement root = XMLLoader.loadDocument((String)outFile.getFullPath().toOSString(), (InputStream)contents);
                return new FXMLConverter(root).generate().toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LoggerCreator.createLogger(((Object)((Object)this)).getClass()).error("Conversion failed", (Throwable)e);
            throw new ExecutionException("Conversion failed", (Throwable)e);
        }
    }

    @Override
    protected String getTargetFileExtension() {
        return ".fxml";
    }
}

