/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import org.eclipse.fx.core.Subscription;
import org.eclipse.fx.core.ThreadQueue;
import org.eclipse.fx.core.log.LoggerCreator;
import org.eclipse.jdt.annotation.NonNull;

public interface ThreadSynchronize {
    public boolean isCurrent();

    public <V> V syncExec(Callable<V> var1, V var2);

    default public <T, R> R syncExec(T value, Function<T, R> function, R defaultValue) {
        Callable<Object> c = () -> function.apply(value);
        return (R)this.syncExec(c, defaultValue);
    }

    public void syncExec(Runnable var1);

    public <V> Future<V> asyncExec(Callable<V> var1);

    public void asyncExec(Runnable var1);

    default public <T> void asyncExec(T value, Consumer<T> consumer) {
        this.asyncExec(() -> consumer.accept(value));
    }

    public Subscription scheduleExecution(long var1, Runnable var3);

    public <T> CompletableFuture<T> scheduleExecution(long var1, Callable<T> var3);

    default public <T> Subscription delayedChangeExecution(final long delay, final ObservableValue<T> property, final Consumer<T> consumer) {
        final ChangeListener l = new ChangeListener<T>(){
            private Subscription currentSubscription;

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                if (this.currentSubscription != null) {
                    this.currentSubscription.dispose();
                }
                this.currentSubscription = ThreadSynchronize.this.scheduleExecution(delay, () -> {
                    consumer.accept(newValue);
                    this.currentSubscription = null;
                });
            }
        };
        property.addListener(l);
        return new Subscription(){

            @Override
            public void dispose() {
                property.removeListener(l);
            }
        };
    }

    default public <T> Subscription delayedChangeExecution(final long delay, Consumer<List<T>> consumer, final ObservableValue<T> ... properties) {
        final Runnable r = () -> {
            ArrayList<Object> l = new ArrayList<Object>();
            ObservableValue[] observableValueArray2 = properties;
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                ObservableValue p = observableValueArray2[n2];
                l.add(p.getValue());
                ++n2;
            }
            consumer.accept(l);
        };
        final ChangeListener l = new ChangeListener<T>(){
            private Subscription currentSubscription;

            public void changed(ObservableValue<? extends T> observable, T oldValue, T newValue) {
                if (this.currentSubscription != null) {
                    this.currentSubscription.dispose();
                }
                this.currentSubscription = ThreadSynchronize.this.scheduleExecution(delay, () -> {
                    r.run();
                    this.currentSubscription = null;
                });
            }
        };
        ObservableValue<T>[] observableValueArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            ObservableValue<T> p = observableValueArray[n2];
            p.addListener(l);
            ++n2;
        }
        return new Subscription(){

            @Override
            public void dispose() {
                ObservableValue[] observableValueArray = properties;
                int n = properties.length;
                int n2 = 0;
                while (n2 < n) {
                    ObservableValue p = observableValueArray[n2];
                    p.removeListener(l);
                    ++n2;
                }
            }
        };
    }

    default public Runnable wrap(Runnable r) {
        return () -> this.asyncExec(r);
    }

    default public <T> Consumer<T> wrap(Consumer<T> c) {
        return t -> this.asyncExec(() -> c.accept(t));
    }

    default public <T, U> BiConsumer<T, U> wrap(BiConsumer<T, U> c) {
        return (t, u) -> this.asyncExec(() -> c.accept(t, u));
    }

    default public <T> Supplier<T> wrap(Supplier<T> s) {
        return () -> this.syncExec(() -> ThreadSynchronize.lambda$9((Supplier)s), null);
    }

    public <T> T block(@NonNull BlockCondition<T> var1);

    public static ThreadSynchronize createBasicThreadSyncronize(ThreadQueue threadQueue) {
        class BasicThreadSynchronize
        implements ThreadSynchronize {
            private Timer timer = new Timer(true);
            private final /* synthetic */ ThreadQueue val$threadQueue;

            BasicThreadSynchronize(ThreadQueue threadQueue) {
                this.val$threadQueue = threadQueue;
            }

            @Override
            public boolean isCurrent() {
                return this.val$threadQueue.isCurrent();
            }

            @Override
            public <V> V syncExec(Callable<V> callable, V defaultValue) {
                if (this.isCurrent()) {
                    try {
                        return callable.call();
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
                FutureTask<V> task = new FutureTask<V>(callable);
                this.asyncExec(task);
                try {
                    Object v = task.get();
                    return v;
                }
                catch (InterruptedException | ExecutionException e) {
                    LoggerCreator.createLogger(this.getClass()).error("Unable to wait until the task is completed", (Throwable)e);
                }
                finally {
                    task.cancel(true);
                }
                return defaultValue;
            }

            @Override
            public void syncExec(Runnable runnable) {
                if (this.isCurrent()) {
                    runnable.run();
                } else {
                    FutureTask<Object> task = new FutureTask<Object>(runnable, null);
                    this.asyncExec(task);
                    try {
                        try {
                            task.get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            LoggerCreator.createLogger(this.getClass()).error("Unable to wait until the task is completed", (Throwable)e);
                            task.cancel(true);
                        }
                    }
                    finally {
                        task.cancel(true);
                    }
                }
            }

            @Override
            public <V> Future<V> asyncExec(Callable<V> callable) {
                FutureTask<V> task = new FutureTask<V>(callable);
                this.asyncExec(task);
                return task;
            }

            @Override
            public void asyncExec(Runnable runnable) {
                this.val$threadQueue.push(runnable);
            }

            @Override
            public Subscription scheduleExecution(long delay, final Runnable runnable) {
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        this.asyncExec(runnable);
                    }
                };
                this.timer.schedule(task, delay);
                return () -> task.cancel();
            }

            @Override
            public <T> CompletableFuture<T> scheduleExecution(long delay, Callable<T> runnable) {
                return CompletableFuture.supplyAsync(() -> {
                    try {
                        Thread.sleep(delay);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    return this.syncExec(runnable, null);
                });
            }

            @Override
            public <T> T block(@NonNull BlockCondition<T> blockCondition) {
                AtomicReference rv = new AtomicReference();
                this.val$threadQueue.spinWhile(blockCondition);
                return (T)rv.get();
            }
        }
        return new BasicThreadSynchronize(threadQueue);
    }

    private static /* synthetic */ Object lambda$9(Supplier supplier) throws Exception {
        return supplier.get();
    }

    public static class BlockCondition<T> {
        List<Consumer<T>> callbacks = new ArrayList<Consumer<T>>();
        private volatile boolean isBlocked = true;
        private T value;

        public Subscription subscribeUnblockedCallback(final Consumer<T> r) {
            if (!this.isBlocked) {
                throw new IllegalStateException();
            }
            this.callbacks.add(r);
            return new Subscription(){

                @Override
                public void dispose() {
                    callbacks.remove(r);
                }
            };
        }

        public boolean isBlocked() {
            return this.isBlocked;
        }

        public void release(T value) {
            this.value = value;
            for (Consumer<T> r : this.callbacks) {
                r.accept(value);
            }
            this.callbacks.clear();
            this.isBlocked = false;
        }

        public T getValue() {
            return this.value;
        }
    }
}

