/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Optional;
import org.eclipse.fx.core.log.LoggerCreator;

public class URLUtils {
    public static URL createUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static URL toURL(URI uri) {
        try {
            return uri.toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }

    public static Optional<URL> createUrl(String url, boolean log) {
        try {
            return Optional.of(new URL(url));
        }
        catch (Throwable e) {
            if (log) {
                LoggerCreator.createLogger(URLUtils.class).error("Failed to create url from '" + url + "'", e);
            }
            return Optional.empty();
        }
    }
}

