/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import org.apache.commons.codec.binary.StringUtils;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.IModificationDate;
import org.eclipse.compare.IStreamContentAccessor;
import org.eclipse.compare.ITypedElement;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.CreateDraftCommand;
import org.eclipse.egerrit.internal.core.command.DeleteDraftCommand;
import org.eclipse.egerrit.internal.core.command.UpdateDraftCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.CommentInput;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.ModelHelpers;
import org.eclipse.egerrit.internal.ui.compare.CommentAnnotationManager;
import org.eclipse.egerrit.internal.ui.compare.CommentExtractor;
import org.eclipse.egerrit.internal.ui.compare.CommentPrettyPrinter;
import org.eclipse.egerrit.internal.ui.compare.GerritCommentAnnotation;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.AnnotationModel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.core.IFileContentManager;
import org.eclipse.team.core.Team;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommentableCompareItem
extends Document
implements ITypedElement,
IModificationDate,
IEditableContent,
IStreamContentAccessor {
    private Logger logger = LoggerFactory.getLogger(CommentableCompareItem.class);
    private IDocument originalDocument;
    private AnnotationModel originalComments;
    private AnnotationModel editableComments;
    protected GerritClient gerrit;
    protected FileInfo fileInfo;
    private boolean dataLoaded = false;
    private final String commentSide;
    private String fileType = "???";
    private byte[] binaryFileContent;

    public CommentableCompareItem(String commentSide) {
        this.commentSide = commentSide;
    }

    void setOriginalDocument(IDocument documentWithComments) {
        this.originalDocument = documentWithComments;
    }

    void setOriginalComments(AnnotationModel gerritComments) {
        this.originalComments = gerritComments;
    }

    public void setEditableComments(AnnotationModel gerritComments) {
        this.editableComments = gerritComments;
    }

    void setGerritConnection(GerritClient gerrit) {
        this.gerrit = gerrit;
    }

    void setFile(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public Image getImage() {
        return null;
    }

    public long getModificationDate() {
        return 0L;
    }

    public String getType() {
        return this.fileType;
    }

    public boolean isEditable() {
        return !this.gerrit.getRepository().getServerInfo().isAnonymous() && !"D".equals(this.fileInfo.getStatus()) && !this.isBinary();
    }

    public void setContent(byte[] newContent) {
        CommentExtractor extractor = new CommentExtractor();
        this.logger.debug("Sending additions: " + extractor.getAddedComments().size() + " removals: " + extractor.getRemovedComments().size() + " modifications: " + extractor.getModifiedComments().size());
        extractor.extractComments(this.originalDocument, this.originalComments, (IDocument)this, this.editableComments);
        for (CommentInfo newComment : extractor.getAddedComments()) {
            CreateDraftCommand publishDraft = this.gerrit.createDraftComments(this.getChangeId(), this.fileInfo.getRevision().getId());
            newComment.setSide(this.commentSide);
            newComment.setPath(this.fileInfo.getPath());
            publishDraft.setCommandInput(newComment);
            try {
                this.logger.debug("Adding comment: " + newComment);
                this.fileInfo.getDraftComments().add((Object)((CommentInfo)publishDraft.call()));
            }
            catch (EGerritException eGerritException) {
                throw new RuntimeException(CommentableCompareItem.class.getName(), new Throwable(String.valueOf(((Object)((Object)this)).hashCode())));
            }
        }
        for (CommentInfo deletedComment : extractor.getRemovedComments()) {
            this.processDraftDeletion(deletedComment);
        }
        for (CommentInfo modifiedComment : extractor.getModifiedComments()) {
            if (modifiedComment.getId() != null && modifiedComment.getMessage().isEmpty()) {
                this.processDraftDeletion(modifiedComment);
                continue;
            }
            UpdateDraftCommand modifyDraft = this.gerrit.updateDraftComments(this.getChangeId(), this.fileInfo.getRevision().getId(), modifiedComment.getId());
            modifyDraft.setCommandInput((Object)CommentInput.fromCommentInfo((CommentInfo)modifiedComment));
            try {
                this.logger.debug("Modifying comment: " + modifiedComment);
                modifyDraft.call();
            }
            catch (EGerritException eGerritException) {
                throw new RuntimeException(CommentableCompareItem.class.getName(), new Throwable(String.valueOf(((Object)((Object)this)).hashCode())));
            }
        }
    }

    private void processDraftDeletion(CommentInfo deletedComment) {
        DeleteDraftCommand deleteDraft = this.gerrit.deleteDraft(this.getChangeId(), this.fileInfo.getRevision().getId(), deletedComment.getId());
        try {
            this.logger.debug("Deleting comment: " + deletedComment);
            deleteDraft.call();
            this.fileInfo.getDraftComments().remove((Object)deletedComment);
        }
        catch (EGerritException eGerritException) {
            throw new RuntimeException(CommentableCompareItem.class.getName(), new Throwable(String.valueOf(((Object)((Object)this)).hashCode())));
        }
    }

    private void loadComments() {
        QueryHelpers.loadComments(this.gerrit, this.fileInfo.getRevision());
        QueryHelpers.loadDrafts(this.gerrit, this.fileInfo.getRevision());
    }

    protected String getChangeId() {
        return this.fileInfo.getRevision().getChangeInfo().getId();
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        return null;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public AnnotationModel getEditableComments() {
        return this.editableComments;
    }

    public InputStream getContents() throws CoreException {
        this.prefetch();
        if (this.isBinary()) {
            return new ByteArrayInputStream(this.binaryFileContent);
        }
        return new ByteArrayInputStream(this.get().getBytes());
    }

    private void prefetch() {
        if (this.dataLoaded) {
            return;
        }
        QueryHelpers.markAsReviewed(this.gerrit, this.fileInfo);
        this.loadComments();
        byte[] fileContent = this.loadFileContent();
        if (!this.isBinary()) {
            this.mergeCommentsInText(StringUtils.newStringUtf8((byte[])fileContent));
        } else {
            this.binaryFileContent = fileContent;
        }
        this.dataLoaded = true;
    }

    protected abstract byte[] loadFileContent();

    private void mergeCommentsInText(String text) {
        CommentAnnotationManager originalComments = new CommentAnnotationManager();
        Document originalDocument = new Document(text);
        originalDocument.set(text);
        originalComments.connect((IDocument)originalDocument);
        this.setOriginalComments(originalComments);
        this.setOriginalDocument((IDocument)originalDocument);
        CommentAnnotationManager editableComments = new CommentAnnotationManager();
        this.set(text);
        editableComments.connect((IDocument)this);
        this.setEditableComments(editableComments);
        if (this.fileInfo.getAllComments().isEmpty()) {
            return;
        }
        EList sortedComments = ModelHelpers.sortComments(this.filterComments((EList<CommentInfo>)this.fileInfo.getAllComments()));
        Collections.reverse(sortedComments);
        for (CommentInfo commentInfo : sortedComments) {
            try {
                int insertionLineInDocument = 0;
                int insertionPosition = 0;
                String lineDelimiter = "";
                if (commentInfo.getLine() > 0) {
                    insertionLineInDocument = commentInfo.getLine() - 1;
                    IRegion lineInfo = originalDocument.getLineInformation(insertionLineInDocument);
                    lineDelimiter = originalDocument.getLineDelimiter(insertionLineInDocument);
                    insertionPosition = lineInfo.getOffset() + lineInfo.getLength() + (lineDelimiter == null ? 0 : lineDelimiter.length());
                }
                int commentTextIndex = insertionPosition;
                String formattedComment = CommentPrettyPrinter.printComment(commentInfo);
                int commentTextLength = formattedComment.length();
                if (lineDelimiter == null) {
                    formattedComment = String.valueOf(originalDocument.getDefaultLineDelimiter()) + formattedComment;
                    commentTextIndex += originalDocument.getDefaultLineDelimiter().length();
                }
                formattedComment = String.valueOf(formattedComment) + originalDocument.getDefaultLineDelimiter();
                originalDocument.replace(insertionPosition, 0, formattedComment);
                this.replace(insertionPosition, 0, formattedComment);
                originalComments.addAnnotation(new GerritCommentAnnotation(commentInfo, formattedComment), new Position(commentTextIndex, commentTextLength));
                editableComments.addAnnotation(new GerritCommentAnnotation(commentInfo, formattedComment), new Position(commentTextIndex, commentTextLength));
            }
            catch (BadLocationException e) {
                this.logger.debug("Exception merging text and comments.", (Throwable)e);
            }
        }
    }

    protected abstract EList<CommentInfo> filterComments(EList<CommentInfo> var1);

    public void reset() {
        this.dataLoaded = false;
    }

    protected boolean isBinary() {
        IFileContentManager manager = Team.getFileContentManager();
        return manager.getTypeForExtension(this.getType()) == 2;
    }

    public void setFileType(String fileType) {
        if (fileType == null) {
            this.fileType = "???";
            return;
        }
        int lastSlash = fileType.lastIndexOf(47);
        this.fileType = lastSlash == -1 ? fileType : fileType.substring(lastSlash + 1);
    }
}

