/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.util.EContentAdapter;

public class ModelLoader {
    private static Map<ChangeInfo, ModelLoader> loaders = new HashMap<ChangeInfo, ModelLoader>();
    private ChangeInfo changeInfo;
    private GerritClient gerritClient;
    private Adapter currentRevisionTracker = null;
    private Adapter detailsTracker = null;
    private Adapter basicInfoTracker = null;
    private int refCount = 0;

    private ModelLoader(GerritClient gerritClient, ChangeInfo changeInfo) {
        this.changeInfo = changeInfo;
        this.gerritClient = gerritClient;
    }

    public static ModelLoader initialize(GerritClient client, ChangeInfo changeInfo) {
        ModelLoader match = loaders.get(changeInfo);
        if (match == null) {
            match = new ModelLoader(client, changeInfo);
            loaders.put(changeInfo, match);
        }
        ++match.refCount;
        return match;
    }

    public void loadBasicInformation() {
        CompletableFuture.runAsync(() -> QueryHelpers.loadBasicInformation(this.gerritClient, this.changeInfo));
        this.initializeBasicInformationTracker();
    }

    private void initializeDetailsTracker() {
        if (this.detailsTracker == null) {
            this.detailsTracker = new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getFeature() == null) {
                        return;
                    }
                    if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__UPDATED)) {
                        CompletableFuture.runAsync(() -> QueryHelpers.loadDetailedInformation(ModelLoader.this.gerritClient, ModelLoader.this.changeInfo));
                    }
                }
            };
            this.changeInfo.eAdapters().add((Object)this.detailsTracker);
        }
    }

    public void loadDetailedInformation() {
        CompletableFuture.runAsync(() -> QueryHelpers.loadDetailedInformation(this.gerritClient, this.changeInfo));
        this.initializeDetailsTracker();
    }

    private void initializeBasicInformationTracker() {
        if (this.basicInfoTracker == null) {
            this.basicInfoTracker = new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getFeature() == null) {
                        return;
                    }
                    if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__UPDATED)) {
                        CompletableFuture.runAsync(() -> QueryHelpers.loadBasicInformation(ModelLoader.this.gerritClient, ModelLoader.this.changeInfo));
                    }
                }
            };
            this.changeInfo.eAdapters().add((Object)this.basicInfoTracker);
        }
    }

    public void loadCurrentRevision() {
        this.loadRevision(this.changeInfo.getCurrent_revision());
    }

    private void loadRevision(String revision) {
        CompletableFuture.runAsync(() -> QueryHelpers.loadRevisionDetails(this.gerritClient, (RevisionInfo)this.changeInfo.getRevisions().get((Object)revision)));
        this.initializeCurrentRevisionTracker();
    }

    private void initializeCurrentRevisionTracker() {
        if (this.currentRevisionTracker == null) {
            this.currentRevisionTracker = new EContentAdapter(){

                public void notifyChanged(Notification msg) {
                    super.notifyChanged(msg);
                    if (msg.getFeature() == null) {
                        return;
                    }
                    if (msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__UPDATED) || msg.getFeature().equals(ModelPackage.Literals.CHANGE_INFO__USER_SELECTED_REVISION)) {
                        CompletableFuture.runAsync(() -> QueryHelpers.loadRevisionDetails(ModelLoader.this.gerritClient, ModelLoader.this.changeInfo.getUserSelectedRevision()));
                    }
                }
            };
            this.changeInfo.eAdapters().add((Object)this.currentRevisionTracker);
        }
    }

    public void dispose() {
        --this.refCount;
        if (this.refCount == 0) {
            if (this.currentRevisionTracker != null) {
                this.changeInfo.eAdapters().remove((Object)this.currentRevisionTracker);
            }
            if (this.detailsTracker != null) {
                this.changeInfo.eAdapters().remove((Object)this.detailsTracker);
            }
            if (this.basicInfoTracker != null) {
                this.changeInfo.eAdapters().remove((Object)this.basicInfoTracker);
            }
            loaders.remove(this.changeInfo);
        }
    }

    public void reload() {
        this.loadBasicInformation();
    }
}

