/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.utils;

import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.CreateDraftCommand;
import org.eclipse.egerrit.internal.core.command.SetReviewCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.core.rest.ReviewInput;
import org.eclipse.egerrit.internal.core.utils.Utils;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.CommentInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.ModelFactory;
import org.eclipse.egerrit.internal.model.ModelHelpers;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.EGerritUIPlugin;
import org.eclipse.egerrit.internal.ui.compare.CommentPrettyPrinter;
import org.eclipse.egerrit.internal.ui.editors.ChangeDetailEditor;
import org.eclipse.egerrit.internal.ui.editors.OpenCompareEditor;
import org.eclipse.egerrit.internal.ui.editors.QueryHelpers;
import org.eclipse.egerrit.internal.ui.editors.ReplyDialog;
import org.eclipse.egerrit.internal.ui.editors.model.ChangeDetailEditorInput;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UIUtils {
    private static Logger logger = LoggerFactory.getLogger(UIUtils.class);
    private static final String EGERRIT_PREF = "org.eclipse.egerrit.prefs";
    private static final int TITLE_LENGTH = 75;

    public static void displayInformation(final Shell shell, final String title, final String message) {
        PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                MessageDialog.openInformation((Shell)shell, (String)title, (String)message);
            }
        });
    }

    public static Point computeFontSize(Composite composite) {
        GC gc = new GC((Drawable)composite);
        FontMetrics fm = gc.getFontMetrics();
        int charWidth = fm.getAverageCharWidth();
        gc.dispose();
        return new Point(charWidth, fm.getHeight());
    }

    public static String getLinkText(String text) {
        text = text.replaceFirst("<a>", "");
        text = text.replaceFirst("</a>", "");
        return text.trim();
    }

    public static void replyToChange(Shell shell, final RevisionInfo revisionInfo, String reason, final GerritClient client, final boolean waitForDataRefresh) {
        final String current = revisionInfo.getId();
        final ReplyDialog replyDialog = new ReplyDialog(shell, reason, revisionInfo, client);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                int ret = replyDialog.open();
                if (ret == 0) {
                    ReviewInput reviewInput = new ReviewInput();
                    reviewInput.setMessage(replyDialog.getValue());
                    reviewInput.setLabels(replyDialog.getRadiosSelection());
                    reviewInput.setDrafts("PUBLISH");
                    CompletionStage reloading = CompletableFuture.runAsync(() -> {
                        try {
                            SetReviewCommand reviewToEmit = client.setReview(revisionInfo.getChangeInfo().getId(), current);
                            reviewToEmit.setCommandInput((Object)reviewInput);
                            reviewToEmit.call();
                        }
                        catch (EGerritException e1) {
                            EGerritCorePlugin.logError((String)(String.valueOf(client.getRepository().formatGerritVersion()) + e1.getMessage()));
                        }
                    }).thenRun(() -> QueryHelpers.loadBasicInformation(client, revisionInfo.getChangeInfo(), false));
                    if (waitForDataRefresh) {
                        ((CompletableFuture)reloading).join();
                    }
                }
            }
        });
    }

    public static String revisionToString(RevisionInfo revisionInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(Integer.toString(revisionInfo.get_number()));
        sb.append("   ");
        UIUtils.appendCommitTime(sb, revisionInfo);
        sb.append("   ");
        UIUtils.appendUserCommiter(sb, revisionInfo);
        if (revisionInfo.isDraft()) {
            sb.append(Messages.UIUtils_0);
        }
        return sb.toString();
    }

    public static void postReply(GerritClient gerritClient, CommentInfo comment, String reply, String revisionId) {
        if (reply.trim().length() == 0) {
            return;
        }
        CreateDraftCommand publishDraft = gerritClient.createDraftComments(ModelHelpers.getRevision((CommentInfo)comment).getChangeInfo().getId(), revisionId);
        CommentInfo replyData = ModelFactory.eINSTANCE.createCommentInfo();
        replyData.setMessage(reply);
        replyData.setInReplyTo(comment.getId());
        replyData.setLine(comment.getLine());
        replyData.setSide(comment.getSide());
        replyData.setPath(ModelHelpers.getFileInfo((CommentInfo)comment).getPath());
        publishDraft.setCommandInput(replyData);
        try {
            ModelHelpers.getFileInfo((CommentInfo)comment).getDraftComments().add((Object)((CommentInfo)publishDraft.call()));
        }
        catch (EGerritException e) {
            EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e.getMessage()));
        }
    }

    private static void appendCommitTime(StringBuilder sb, RevisionInfo revisionInfo) {
        if (revisionInfo.getCommit() != null) {
            sb.append(Utils.formatDate((String)revisionInfo.getCommit().getCommitter().getDate(), (SimpleDateFormat)new SimpleDateFormat("MMM dd, yyyy hh:mm a")));
        }
    }

    private static void appendUserCommiter(StringBuilder sb, RevisionInfo revisionInfo) {
        if (revisionInfo.getCommit() != null) {
            if (revisionInfo.getCommit().getAuthor() != null) {
                sb.append(revisionInfo.getCommit().getAuthor().getName());
            }
            if (!revisionInfo.getCommit().getAuthor().getName().equals(revisionInfo.getCommit().getCommitter().getName())) {
                sb.append("/");
                sb.append(revisionInfo.getCommit().getCommitter().getName());
            }
        }
    }

    public static String formatMessageForMarkerView(CommentInfo commentInfo) {
        String patchSet = String.valueOf(ModelHelpers.getRevision((CommentInfo)commentInfo).get_number()) + "/" + ModelHelpers.getHighestRevisionNumber((Collection)ModelHelpers.getRevision((CommentInfo)commentInfo).getChangeInfo().getRevisions().values());
        String author = commentInfo.getAuthor() != null ? commentInfo.getAuthor().getName() : Messages.UIUtils_1;
        return String.valueOf(commentInfo.getMessage()) + Messages.UIUtils_2 + author + Messages.UIUtils_3 + CommentPrettyPrinter.printDate(commentInfo) + Messages.UIUtils_4 + patchSet + Messages.UIUtils_5;
    }

    public static String formatMessageForQuickFix(CommentInfo commentInfo) {
        String message = commentInfo.getMessage();
        if (message.length() < 20) {
            return message;
        }
        int nextSpace = message.indexOf(32, 20);
        if (nextSpace == -1) {
            return message;
        }
        return String.valueOf(message.substring(0, nextSpace)) + " ...";
    }

    public static String getPatchSetString(CommentInfo comment) {
        return UIUtils.getPatchSetString(ModelHelpers.getRevision((CommentInfo)comment));
    }

    public static String getPatchSetString(RevisionInfo revision) {
        return String.valueOf(revision.get_number()) + "/" + ModelHelpers.getHighestRevisionNumber((Collection)revision.getChangeInfo().getRevisions().values());
    }

    public static void open(GerritClient gerritClient, FileInfo fileInfo, ChangeInfo changeInfo, String leftSide) {
        OpenCompareEditor compareEditor = new OpenCompareEditor(gerritClient, changeInfo);
        compareEditor.compareFiles(leftSide, fileInfo.getRevision().getId(), fileInfo);
    }

    public static boolean openSingleFile(Object key, GerritClient gerritClient, RevisionInfo revInfo, int line) {
        FileInfo fileInfo = (FileInfo)revInfo.getFiles().get(key);
        if (fileInfo != null) {
            IFile workspaceFile = new OpenCompareEditor(gerritClient, revInfo.getChangeInfo()).getCorrespondingWorkspaceFile(fileInfo);
            if (workspaceFile == null) {
                return false;
            }
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IWorkbenchPage page = window.getActivePage();
            try {
                IDE.openEditor((IWorkbenchPage)page, (IFile)workspaceFile);
            }
            catch (PartInitException e1) {
                logger.debug("Failed to delete marker", (Throwable)e1);
            }
        }
        return true;
    }

    public static void showDialogTip(String key, Shell shell, String title, String value) {
        MessageDialogWithToggle dialog;
        IEclipsePreferences prefs = ConfigurationScope.INSTANCE.getNode(EGERRIT_PREF);
        Preferences editorPrefs = prefs.node(key);
        boolean choice = editorPrefs.getBoolean(key, false);
        if (choice) {
            return;
        }
        if (title.length() > 75) {
            title = title.substring(0, 72).concat("...");
        }
        if ((dialog = MessageDialogWithToggle.openInformation((Shell)shell, (String)title, (String)value, (String)Messages.UIUtils_EGerriTipShowAgain, (boolean)false, null, null)).getToggleState()) {
            editorPrefs.putBoolean(key, true);
            try {
                editorPrefs.flush();
            }
            catch (BackingStoreException backingStoreException) {}
        }
    }

    public static void openAnotherEditor(ChangeInfo changeInfo, GerritClient fGerritClient) {
        IWorkbench workbench = EGerritUIPlugin.getDefault().getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage page = null;
        if (window != null) {
            page = workbench.getActiveWorkbenchWindow().getActivePage();
        }
        if (page != null) {
            try {
                ChangeDetailEditorInput input = new ChangeDetailEditorInput(fGerritClient, changeInfo);
                IEditorPart reusedEditor = page.findEditor((IEditorInput)input);
                page.openEditor((IEditorInput)input, "org.eclipse.egerrit.ui.editors.ChangeDetailEditor");
                if (reusedEditor instanceof ChangeDetailEditor) {
                    ((ChangeDetailEditor)reusedEditor).refreshStatus();
                }
            }
            catch (PartInitException e) {
                EGerritCorePlugin.logError((String)(fGerritClient != null ? String.valueOf(fGerritClient.getRepository().formatGerritVersion()) + e.getMessage() : e.getMessage()));
            }
        }
    }
}

