/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.dashboard.ui.commands.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.dashboard.ui.GerritUi;
import org.eclipse.egerrit.internal.dashboard.ui.views.GerritTableView;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.process.ReplyProcess;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class VoteMenuGenerator
extends CompoundContributionItem
implements IWorkbenchContribution {
    public static final String VIEW_ID = "org.eclipse.egerrit.dashboard.ui.views.GerritTableView";
    private GerritClient fGerritClient;
    private IServiceLocator fServiceLocator;

    protected IContributionItem[] getContributionItems() {
        IContributionItem[] contributionItems = null;
        IWorkbench workbench = GerritUi.getDefault().getWorkbench();
        IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
        IViewPart viewPart = page.findView(VIEW_ID);
        if (viewPart != null && viewPart instanceof GerritTableView) {
            GerritTableView gerritTable = (GerritTableView)viewPart;
            this.fGerritClient = gerritTable.getGerritClient();
            contributionItems = this.getData();
        }
        return contributionItems;
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.fServiceLocator = serviceLocator;
    }

    private IContributionItem[] getData() {
        ISelection selection = ((ISelectionService)this.fServiceLocator.getService(ISelectionService.class)).getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return new IContributionItem[0];
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        for (Object element : structuredSelection) {
            if (!(element instanceof ChangeInfo)) continue;
            ChangeInfo changeInfo = (ChangeInfo)element;
            String loginUser = this.fGerritClient.getRepository().getServerInfo().getUserName();
            Map labelsToCreateEntryFor = changeInfo.getLabelsNotAtMax(loginUser);
            if (labelsToCreateEntryFor.isEmpty()) {
                return new IContributionItem[0];
            }
            ArrayList<ContributionItem> menusForVotes = new ArrayList<ContributionItem>();
            for (Map.Entry label : labelsToCreateEntryFor.entrySet()) {
                menusForVotes.add(this.createItem((String)label.getKey(), String.valueOf(label.getValue()), String.valueOf((String)label.getKey()) + "  +" + label.getValue()));
            }
            if (menusForVotes.size() > 1) {
                menusForVotes.add(this.createItem(ReplyProcess.REPLY_ALL_BUTTONS, null, ReplyProcess.REPLY_ALL_BUTTONS));
            }
            return menusForVotes.toArray(new IContributionItem[menusForVotes.size()]);
        }
        return new IContributionItem[0];
    }

    private ContributionItem createItem(String key, String value, String menuLabel) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org.eclipse.egerrit.dashboard.ui.vote.label", key);
        params.put("org.eclipse.egerrit.dashboard.ui.vote.value", value);
        CommandContributionItemParameter menuEntry = new CommandContributionItemParameter(this.fServiceLocator, menuLabel, "org.eclipse.egerrit.dashboard.ui.vote", params, null, null, null, menuLabel, menuLabel, menuLabel, 8, null, true);
        return new CommandContributionItem(menuEntry);
    }
}

