/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.builder;

import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egf.core.fcore.IResourceFcoreDelta;
import org.eclipse.egf.core.fcore.IResourceFcoreListener;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.engine.TranslationHelper;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcoreListener
implements IResourceFcoreListener {
    public static final FcoreListener INSTANCE = new FcoreListener();

    public void fcoreChanged(IResourceFcoreDelta delta) {
        this.translate(delta.getUpdatedFcores());
    }

    private void translate(final List<URI> uris) {
        if (uris == null || uris.size() == 0) {
            return;
        }
        Job job = new Job(Messages.translation_job_label){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    new WorkspaceModifyOperation(){

                        protected void execute(IProgressMonitor innerMonitor) throws CoreException, InvocationTargetException, InterruptedException {
                            HashSet patterns = new HashSet();
                            PatternHelper patternCollector = PatternHelper.createCollector();
                            try {
                                try {
                                    innerMonitor.beginTask(Messages.translation_job_label, uris.size());
                                    for (URI uri : uris) {
                                        patterns.addAll(patternCollector.getPatterns(uri));
                                    }
                                    new TranslationHelper().translate(patterns);
                                }
                                catch (Exception e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            finally {
                                patterns.clear();
                                patternCollector.clear();
                            }
                        }
                    }.run(monitor);
                }
                catch (InvocationTargetException e) {
                    Activator.getDefault().logError(e.getTargetException());
                }
                catch (InterruptedException e) {
                    Activator.getDefault().logError(e);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }
}

