/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.builder;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.Activator;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.egf.pattern.engine.TranslationHelper;

public class PatternBuilder
extends IncrementalProjectBuilder {
    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        Set<String> patternIds = null;
        IResourceDelta delta = this.getDelta(this.getProject());
        if (delta != null && delta.getKind() != 0) {
            PatternVisitor patternVisitor = new PatternVisitor();
            delta.accept((IResourceDeltaVisitor)patternVisitor);
            patternIds = patternVisitor.getPatternId2translate();
            if (patternIds.isEmpty()) {
                return null;
            }
        }
        this.checkCancellation(monitor);
        PatternHelper helper = PatternHelper.createCollector();
        List patterns = helper.getPatterns(this.getProject(), patternIds);
        try {
            try {
                new TranslationHelper().translate(patterns);
            }
            catch (PatternException e) {
                Activator.getDefault().logError(Messages.PatternBuilding_Failed, (Throwable)e);
                helper.clear();
                patterns.clear();
            }
        }
        finally {
            helper.clear();
            patterns.clear();
        }
        return null;
    }

    private void checkCancellation(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class PatternVisitor
    implements IResourceDeltaVisitor {
        private final Set<String> patternId2translate = new HashSet<String>();

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.getType() == 1) {
                if (delta.getKind() != 2 && "pt".equals(resource.getFileExtension())) {
                    try {
                        this.patternId2translate.add(PatternHelper.Filename.extractPatternId((IPath)resource.getProjectRelativePath()));
                    }
                    catch (PatternHelper.FilenameFormatException e) {
                        Activator.getDefault().logError((Throwable)e);
                    }
                }
                return false;
            }
            return true;
        }

        public Set<String> getPatternId2translate() {
            return this.patternId2translate;
        }
    }
}

