/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.dialogs;

import org.eclipse.egf.model.fcore.NamedModelElement;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.PatternVariable;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.providers.ParametersTableLabelProvider;
import org.eclipse.egf.pattern.ui.editors.wizards.OpenTypeWizard;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionStatusDialog;

public class VariablesEditDialog
extends SelectionStatusDialog {
    private Text _nameText;
    private Text _typeText;
    private String _name;
    private String _typeName;
    private String _type;
    private EditingDomain _editingDomain;
    private EObject _current;

    public VariablesEditDialog(Shell shell, Object selectItem, TransactionalEditingDomain editingDomain) {
        super(shell);
        this._editingDomain = editingDomain;
        this.setDefaultValue(selectItem);
    }

    private void setDefaultValue(Object selectItem) {
        if (selectItem instanceof PatternVariable) {
            PatternVariable patternVariable = (PatternVariable)selectItem;
            this._type = patternVariable.getType();
            this._current = patternVariable;
            this.setValue((NamedModelElement)patternVariable);
        } else if (selectItem instanceof PatternParameter) {
            PatternParameter patternParameter = (PatternParameter)selectItem;
            this._type = patternParameter.getType();
            this._current = patternParameter;
            this.setValue((NamedModelElement)patternParameter);
        }
    }

    private void setValue(NamedModelElement selection) {
        this._name = selection.getName();
        this._typeName = ParametersTableLabelProvider.getType(this._type);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        composite.setLayout((Layout)layout);
        VariablesEditDialog.createLabel(composite, Messages.ParametersEditDialog_Name);
        this._nameText = new Text(composite, 2048);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this._nameText.setLayoutData((Object)gd);
        this._nameText.setText(this._name);
        this._nameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariablesEditDialog.this._name = VariablesEditDialog.this._nameText.getText();
            }
        });
        VariablesEditDialog.createLabel(composite, Messages.ParametersEditDialog_Type);
        this._typeText = new Text(composite, 2056);
        gd = new GridData(768);
        this._typeText.setLayoutData((Object)gd);
        this._typeText.setText(this._typeName);
        this._typeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariablesEditDialog.this._typeName = VariablesEditDialog.this._typeText.getText();
            }
        });
        Button typeButton = new Button(composite, 8);
        gd = new GridData();
        typeButton.setLayoutData((Object)gd);
        typeButton.setText(Messages.ParametersEditDialog_Browse);
        typeButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                OpenTypeWizard wizard = new OpenTypeWizard(VariablesEditDialog.this._editingDomain, VariablesEditDialog.this._type, VariablesEditDialog.this._current);
                wizard.init(PlatformUI.getWorkbench(), null);
                WizardDialog dialog = new WizardDialog(VariablesEditDialog.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    Object object = wizard.getSelectType();
                    if (object instanceof EObject) {
                        VariablesEditDialog.this._type = EcoreUtil.getURI((EObject)((EObject)object)).toString();
                        VariablesEditDialog.this._typeText.setText(ParametersTableLabelProvider.getType(VariablesEditDialog.this._type));
                    } else if (object instanceof IType) {
                        VariablesEditDialog.this._type = ((IType)object).getFullyQualifiedName();
                        VariablesEditDialog.this._typeText.setText(((IType)object).getElementName());
                    }
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return composite;
    }

    public static Label createLabel(Composite parent, String content) {
        Label label = new Label(parent, 0);
        label.setText(content);
        return label;
    }

    public String getName() {
        return this._name;
    }

    public String getType() {
        return this._type;
    }

    protected void computeResult() {
    }
}

