/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.templateEditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.egf.pattern.ui.editors.PatternMethodEditorInput;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.part.MultiPageEditorSite;

public abstract class MethodEditorActivationListener
implements IPartListener,
IWindowListener {
    private IPartService fPartService;
    private TextEditor textEditor;

    public MethodEditorActivationListener(IPartService partService, TextEditor editor) {
        this.textEditor = editor;
        this.fPartService = partService;
        this.fPartService.addPartListener((IPartListener)this);
        PlatformUI.getWorkbench().addWindowListener((IWindowListener)this);
    }

    public void partActivated(IWorkbenchPart part) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        IWorkbenchPage activePage = activeWorkbenchWindow.getActivePage();
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (activeEditor == this.getMultiPageEditor()) {
            this.gotoCheck();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void windowActivated(IWorkbenchWindow window) {
        IEditorSite editorSite = this.textEditor.getEditorSite();
        IWorkbenchPage activePage = window.getActivePage();
        IEditorPart activeEditor = activePage.getActiveEditor();
        if (window == editorSite.getWorkbenchWindow() && this.getMultiPageEditor() == activeEditor) {
            window.getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    MethodEditorActivationListener.this.gotoCheck();
                }
            });
        }
    }

    public void windowClosed(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowOpened(IWorkbenchWindow window) {
    }

    public void dispose() {
        this.fPartService.removePartListener((IPartListener)this);
        PlatformUI.getWorkbench().removeWindowListener((IWindowListener)this);
        this.fPartService = null;
    }

    private IEditorPart getMultiPageEditor() {
        IEditorSite editorSite = this.textEditor.getEditorSite();
        MultiPageEditorPart editor = ((MultiPageEditorSite)editorSite).getMultiPageEditor();
        return editor;
    }

    private void gotoCheck() {
        IEditorInput editorInput = this.textEditor.getEditorInput();
        IFile file = ((PatternMethodEditorInput)editorInput).getFile();
        if (file != null) {
            this.handleActivation();
        }
    }

    protected abstract void handleActivation();
}

