/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.jet.editor;

import org.eclipse.egf.pattern.ui.jet.editor.JetTextEditor;
import org.eclipse.egf.pattern.ui.jet.editor.contentassist.JetJavaExpressionAssistProcessor;
import org.eclipse.egf.pattern.ui.jet.editor.contentassist.JetJavaScriptletAssistProcessor;
import org.eclipse.jet.internal.editor.JETTextEditor;
import org.eclipse.jet.internal.editor.configuration.JETSourceViewerConfiguration;
import org.eclipse.jet.internal.editor.contentassist.JETJavaExpressionAssistProcessor;
import org.eclipse.jet.internal.editor.contentassist.JETJavaScriptletAssistProcessor;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.source.ISourceViewer;

public class JetSourceViewerConfigure
extends JETSourceViewerConfiguration {
    private JETTextEditor editor;

    public JetSourceViewerConfigure(JETTextEditor editor) {
        super(editor);
        this.editor = editor;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        return null;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        ContentAssistant assistant = new ContentAssistant();
        assistant.setDocumentPartitioning(this.getConfiguredDocumentPartitioning(sourceViewer));
        String[] configuredContentTypes = this.getConfiguredContentTypes(sourceViewer);
        int i = 0;
        while (i < configuredContentTypes.length) {
            String contentType = configuredContentTypes[i];
            IContentAssistProcessor processor = this.editor.getPartitionScanner().getCompletionProcessor(contentType, assistant);
            if (processor != null) {
                if (processor instanceof JETJavaScriptletAssistProcessor) {
                    JetJavaScriptletAssistProcessor jetJavaScriptletAssistProcessor = new JetJavaScriptletAssistProcessor((JetTextEditor)this.editor);
                    assistant.setContentAssistProcessor((IContentAssistProcessor)jetJavaScriptletAssistProcessor, contentType);
                } else if (processor instanceof JETJavaExpressionAssistProcessor) {
                    JetJavaExpressionAssistProcessor jetJavaExpressionAssistProcessor = new JetJavaExpressionAssistProcessor((JetTextEditor)this.editor);
                    assistant.setContentAssistProcessor((IContentAssistProcessor)jetJavaExpressionAssistProcessor, contentType);
                } else {
                    assistant.setContentAssistProcessor(processor, contentType);
                }
            }
            ++i;
        }
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        assistant.enableAutoInsert(false);
        assistant.enableAutoActivation(true);
        return assistant;
    }
}

