/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.model.pattern.Call;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.Messages;
import org.eclipse.egf.pattern.engine.AssemblyContentHelper;
import org.eclipse.egf.pattern.engine.AssemblyContentProvider;
import org.eclipse.emf.common.util.EList;

public abstract class AssemblyHelper {
    public static final String GENERATE_METHOD = "generate";
    public static final String ORCHESTRATION_METHOD = "orchestration";
    protected final Pattern pattern;
    protected final StringBuilder content = new StringBuilder(1000);
    protected int orchestrationIndex;
    protected final AssemblyContentHelper contentHelper;

    public AssemblyHelper(Pattern pattern, AssemblyContentProvider contentProvider) {
        this.pattern = pattern;
        this.contentHelper = new AssemblyContentHelper(contentProvider);
        contentProvider.setContent(this.content);
    }

    public String visit() throws PatternException {
        this.orchestrationIndex = -1;
        this.addHeader();
        this.addVariableInitialization();
        this.beginOrchestration();
        if (this.orchestrationIndex == -1) {
            throw new PatternException(Messages.assembly_error6);
        }
        this.visitOrchestration();
        this.endOrchestration();
        this.addMethodBodies();
        this.addFooter();
        return this.content.toString();
    }

    protected void addFooter() throws PatternException {
        String read = this.contentHelper.getMethodContent(this.pattern.getFooterMethod());
        if (read != null) {
            this.content.append(read).append(EGFCommonConstants.LINE_SEPARATOR);
        }
    }

    protected void addHeader() throws PatternException {
        String read = this.contentHelper.getMethodContent(this.pattern.getHeaderMethod());
        if (read != null) {
            this.content.append(read).append(EGFCommonConstants.LINE_SEPARATOR);
        }
    }

    protected void addMethodBodies() throws PatternException {
        this.contentHelper.addMethodBodies();
    }

    protected void endOrchestration() throws PatternException {
    }

    protected void beginOrchestration() throws PatternException {
        this.orchestrationIndex = this.content.length();
    }

    protected abstract void addVariableInitialization() throws PatternException;

    protected void visitOrchestration() throws PatternException {
        EList orchestration = this.pattern.getOrchestration();
        if (orchestration.isEmpty()) {
            return;
        }
        for (Call element : orchestration) {
            this.contentHelper.addContent(element);
        }
    }
}

