/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.jet.engine;

import java.io.InputStream;
import java.util.Map;
import org.eclipse.egf.common.constant.EGFCommonConstants;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.pattern.engine.PatternHelper;
import org.eclipse.emf.codegen.jet.JETCompiler;
import org.eclipse.emf.codegen.jet.JETCoreElement;
import org.eclipse.emf.codegen.jet.JETException;
import org.eclipse.emf.codegen.jet.JETGenerator;
import org.eclipse.emf.codegen.jet.JETMark;
import org.eclipse.emf.codegen.jet.JETParser;
import org.eclipse.emf.codegen.jet.JETScriptletGenerator;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JetTagsCompiler
extends JETCompiler {
    private static final String N = EGFCommonConstants.LINE_SEPARATOR;

    public JetTagsCompiler(String templateURI, InputStream inputStream, String encoding) throws JETException {
        super(templateURI, inputStream, encoding);
    }

    public void handleDirective(String directive, JETMark start, JETMark stop, Map<String, String> attributes) throws JETException {
        if ("egf:patternCall".equals(directive)) {
            String patternId = this.translateId(attributes.get("patternId"));
            String args = attributes.get("args");
            StringBuffer buffer = new StringBuffer();
            buffer.append("{");
            buffer.append(N);
            buffer.append("final Map<String, Object> callParameters");
            buffer.append(" = new HashMap<String, Object>();");
            buffer.append(N);
            if (args != null) {
                String[] stringArray = args.split(",");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String arg = stringArray[n2];
                    int indexOf = arg.indexOf(":");
                    buffer.append("callParameters");
                    buffer.append(".put(\"");
                    buffer.append(arg.substring(indexOf + 1));
                    buffer.append("\", ");
                    buffer.append(arg.substring(0, indexOf));
                    buffer.append(");");
                    buffer.append(N);
                    ++n2;
                }
            }
            buffer.append("CallHelper.executeWithParameterInjection(\"");
            buffer.append(patternId);
            buffer.append("\", new ExecutionContext((InternalPatternContext) ctx), callParameters");
            buffer.append(");");
            buffer.append(N);
            buffer.append("}");
            buffer.append(N);
            this.addGenerator((JETGenerator)new JETScriptletGenerator(buffer.toString().toCharArray()));
        } else if ("egf:patternInjectedCall".equals(directive)) {
            String patternId = this.translateId(attributes.get("patternId"));
            String toInject = attributes.get("toInject");
            StringBuffer buffer = new StringBuffer();
            buffer.append("{");
            buffer.append(N);
            buffer.append("ExecutionContext callCtx");
            buffer.append(" = new ExecutionContext((InternalPatternContext) ctx);");
            buffer.append(N);
            buffer.append("callCtx");
            buffer.append(".setValue(PatternContext.INJECTED_CONTEXT, ");
            buffer.append(toInject);
            buffer.append(");");
            buffer.append(N);
            buffer.append("CallHelper.executeWithContextInjection(\"");
            buffer.append(patternId);
            buffer.append("\", callCtx");
            buffer.append(");");
            buffer.append(N);
            buffer.append("}");
            buffer.append(N);
            this.addGenerator((JETGenerator)new JETScriptletGenerator(buffer.toString().toCharArray()));
        }
        super.handleDirective(directive, start, stop, attributes);
    }

    protected String translateId(String id) {
        if (id != null && id.contains("LogicalName")) {
            URI uri = URI.createURI((String)id);
            String fragment = uri.fragment().substring("LogicalName".length() + 1);
            TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
            Resource resource = editingDomain.getResourceSet().getResource(uri.trimFragment(), true);
            TreeIterator treeIterator = resource.getAllContents();
            while (treeIterator.hasNext()) {
                EObject eObject = (EObject)treeIterator.next();
                if (!(eObject instanceof Pattern)) continue;
                Pattern pattern = (Pattern)eObject;
                StringBuilder buffer = new StringBuilder();
                buffer.append(PatternHelper.getFullLibraryName((Pattern)pattern));
                buffer.append(".");
                buffer.append(pattern.getName());
                if (!buffer.toString().equals(fragment)) continue;
                return uri.trimFragment().appendFragment(pattern.getID()).toString();
            }
        }
        return id;
    }

    protected void parse(JETCoreElement[] coreElements, Class<?>[] accept) throws JETException {
        JETParser.Directive directive = (JETParser.Directive)coreElements[0];
        directive.getDirectives().add("egf:patternInjectedCall");
        directive.getDirectives().add("egf:patternCall");
        super.parse(coreElements, (Class[])accept);
    }
}

