/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.ui.editors.wizards.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.egf.model.pattern.InjectedContext;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternCall;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.model.pattern.impl.Paramerter2ParameterMapImpl;
import org.eclipse.egf.pattern.ui.Activator;
import org.eclipse.egf.pattern.ui.Messages;
import org.eclipse.egf.pattern.ui.editors.providers.CommonListContentProvider;
import org.eclipse.egf.pattern.ui.editors.providers.ParameterMatchingLibraryProvider;
import org.eclipse.egf.pattern.ui.editors.providers.ParametersTableLabelProvider;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParameterMatchingPage
extends WizardPage {
    private Pattern _patternCaller;
    private Pattern _patternCallee;
    private Label _patternCalleeNameLabel;
    private TableViewer _calleeTableViewer;
    private TableViewer _matchingTableViewer;
    private TableViewer _callerTableViewer;
    private Button _createMatch;
    private Button _deleteMatch;
    private Button _editMatch;
    private PatternCall patternCall;
    private TransactionalEditingDomain _editingDomain;
    private List<RecordingCommand> _matchingCommands;

    public ParameterMatchingPage(ISelection selection, Pattern patternCaller, TransactionalEditingDomain editingDomain) {
        super(Messages.ParameterMatchingPage_title);
        this.setTitle(Messages.ParameterMatchingPage_title);
        this.setDescription(Messages.ParameterMatchingPage_label_text);
        this._patternCaller = patternCaller;
        this._editingDomain = editingDomain;
    }

    public void createControl(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        dialogArea.setLayout((Layout)layout);
        this.createParameterArea(dialogArea);
        this.createMatchingArea(dialogArea);
        this.setControl((Control)dialogArea);
    }

    private void createParameterArea(Composite dialogArea) {
        Composite parameterArea = this.createArea(dialogArea, true);
        this.createCallerArea(parameterArea);
        this.createCalleeArea(parameterArea);
        this.createMatingButton(parameterArea);
    }

    private void createMatingButton(Composite parameterArea) {
        this._createMatch = new Button(parameterArea, 8);
        this._createMatch.setText(Messages.ParameterMatchingPage_button_create);
        GridData gd = new GridData();
        gd.widthHint = 200;
        gd.horizontalSpan = 2;
        gd.horizontalAlignment = 0x1000000;
        gd.verticalIndent = 0;
        this._createMatch.setLayoutData((Object)gd);
        this._createMatch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParameterMatchingPage.this.createMatching();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createMatchingArea(Composite dialogArea) {
        Composite parameterArea = this.createArea(dialogArea, false);
        Label currenMatchingLabel = new Label(parameterArea, 0);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 9;
        currenMatchingLabel.setLayoutData((Object)gd);
        currenMatchingLabel.setText(Messages.ParameterMatchingPage_current_mathings_title);
        Table table = new Table(parameterArea, 2816);
        gd = new GridData(1808);
        gd.heightHint = 160;
        gd.horizontalIndent = 7;
        gd.verticalIndent = 0;
        table.setLayoutData((Object)gd);
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setWidth(420);
        this._matchingTableViewer = new TableViewer(table);
        this._matchingTableViewer.setLabelProvider((IBaseLabelProvider)new ParameterMatchingLibraryProvider());
        this._matchingTableViewer.setContentProvider((IContentProvider)new CommonListContentProvider());
        this._matchingTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ParameterMatchingPage.this.checkEidtAndDeleteButtonEnable();
            }
        });
        this.createMatchingAreaButtons(parameterArea);
    }

    private void createMatchingAreaButtons(Composite parameterArea) {
        Composite buttonsArea = new Composite(parameterArea, 0);
        GridLayout layout = new GridLayout();
        buttonsArea.setLayout((Layout)layout);
        this._deleteMatch = this.createButton(buttonsArea);
        this._deleteMatch.setToolTipText(Messages.ParameterMatchingPage_button_delete);
        this._deleteMatch.setText("");
        this._deleteMatch.setImage(Activator.getDefault().getImage("obj16/delete.gif"));
        this._deleteMatch.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ParameterMatchingPage.this.deleteMatching();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this._editMatch = this.createButton(buttonsArea);
        this._editMatch.setToolTipText(Messages.ParameterMatchingPage_button_edit);
        this._editMatch.setText("");
        this._editMatch.setImage(Activator.getDefault().getImage("obj16/edit.gif"));
    }

    private Composite createArea(Composite composite, boolean makeColumnsEqualWidth) {
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, makeColumnsEqualWidth);
        GridData gd = new GridData(1808);
        gd.verticalIndent = 0;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)gd);
        return container;
    }

    private void createCallerArea(Composite dialogArea) {
        Composite callerArea = this.createCallArea(dialogArea);
        this.createPatternNameLabel(callerArea, this._patternCaller);
        this._callerTableViewer = this.createParameterTableViewer(callerArea, this._patternCaller);
        this._callerTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ParameterMatchingPage.this.checkCreateButtonEnable();
            }
        });
    }

    private void createCalleeArea(Composite dialogArea) {
        Composite calleeArea = this.createCallArea(dialogArea);
        this._patternCalleeNameLabel = this.createPatternNameLabel(calleeArea, this._patternCallee);
        this._calleeTableViewer = this.createParameterTableViewer(calleeArea, this._patternCallee);
        this._calleeTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ParameterMatchingPage.this.checkCreateButtonEnable();
            }
        });
    }

    private Label createPatternNameLabel(Composite container, Pattern pattern) {
        Label patternNameLabel = new Label(container, 0);
        GridData gd = new GridData(768);
        patternNameLabel.setLayoutData((Object)gd);
        this.setPatternName(pattern, patternNameLabel);
        return patternNameLabel;
    }

    private TableViewer createParameterTableViewer(Composite container, Pattern pattern) {
        Table listTable = new Table(container, 2816);
        GridData gd = new GridData(1808);
        gd.heightHint = listTable.getItemHeight();
        listTable.setLayoutData((Object)gd);
        TableColumn tableColumn = new TableColumn(listTable, 0);
        tableColumn.setWidth(260);
        TableViewer tableViewer = new TableViewer(listTable);
        tableViewer.setLabelProvider((IBaseLabelProvider)new ParametersTableLabelProvider());
        tableViewer.setContentProvider((IContentProvider)new CommonListContentProvider());
        return tableViewer;
    }

    private Composite createCallArea(Composite container) {
        Composite callArea = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        callArea.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        callArea.setLayoutData((Object)gd);
        return callArea;
    }

    private Button createButton(Composite container) {
        Button button = new Button(container, 8);
        GridData gd = new GridData();
        gd.widthHint = 60;
        button.setLayoutData((Object)gd);
        return button;
    }

    private List<InjectedContext> getCallerTableInput(Pattern pattern) {
        if (pattern == null) {
            return null;
        }
        ArrayList<InjectedContext> result = new ArrayList<InjectedContext>();
        result.addAll((Collection<InjectedContext>)pattern.getAllParameters());
        result.addAll((Collection<InjectedContext>)pattern.getAllVariables());
        return result;
    }

    private List<PatternParameter> getCalleeTableInput(Pattern pattern) {
        if (pattern == null) {
            return null;
        }
        EList parameters = pattern.getAllParameters();
        ArrayList<PatternParameter> availableParameters = new ArrayList<PatternParameter>();
        EMap parameterMatching = this.patternCall.getParameterMatching();
        for (PatternParameter parameter : parameters) {
            if (!this.isAvailableParameter((InjectedContext)parameter, (EMap<InjectedContext, InjectedContext>)parameterMatching)) continue;
            availableParameters.add(parameter);
        }
        return availableParameters;
    }

    private boolean isAvailableParameter(InjectedContext parameter, EMap<InjectedContext, InjectedContext> parameterMatching) {
        int i = 0;
        while (i < parameterMatching.size()) {
            Map.Entry currentEntry = (Map.Entry)parameterMatching.get(i);
            InjectedContext currentKey = (InjectedContext)currentEntry.getKey();
            if (currentKey.equals(parameter)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void checkCreateButtonEnable() {
        if (this.getSelection(this._callerTableViewer) != null && this.getSelection(this._calleeTableViewer) != null) {
            this._createMatch.setEnabled(true);
        } else {
            this._createMatch.setEnabled(false);
        }
    }

    private void checkEidtAndDeleteButtonEnable() {
        if (this.getSelection(this._matchingTableViewer) != null) {
            this._deleteMatch.setEnabled(true);
            this._editMatch.setEnabled(true);
        } else {
            this._deleteMatch.setEnabled(false);
            this._editMatch.setEnabled(false);
        }
    }

    private Object getSelection(TableViewer tableViewer) {
        int selectionIndex = tableViewer.getTable().getSelectionIndex();
        if (selectionIndex != -1) {
            return tableViewer.getElementAt(selectionIndex);
        }
        return null;
    }

    private void createMatching() {
        final InjectedContext callerObj = (InjectedContext)this.getSelection(this._callerTableViewer);
        final InjectedContext calleeObj = (InjectedContext)this.getSelection(this._calleeTableViewer);
        int selectIndex = this._calleeTableViewer.getTable().getSelectionIndex();
        RecordingCommand cmd = new RecordingCommand(this._editingDomain){

            protected void doExecute() {
                ParameterMatchingPage.this.patternCall.getParameterMatching().put((Object)calleeObj, (Object)callerObj);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)cmd);
        this._matchingCommands.add(cmd);
        this.refreshTables();
        this.setSelection(this._calleeTableViewer, selectIndex);
    }

    private void deleteMatching() {
        final Paramerter2ParameterMapImpl deleteItem = (Paramerter2ParameterMapImpl)this.getSelection(this._matchingTableViewer);
        int selectIndex = this._matchingTableViewer.getTable().getSelectionIndex();
        RecordingCommand cmd = new RecordingCommand(this._editingDomain){

            protected void doExecute() {
                ParameterMatchingPage.this.patternCall.getParameterMatching().remove((Object)deleteItem);
            }
        };
        this._editingDomain.getCommandStack().execute((Command)cmd);
        this._matchingCommands.add(cmd);
        this.refreshTables();
        this.setSelection(this._matchingTableViewer, selectIndex);
    }

    private void refreshTables() {
        this._matchingTableViewer.setInput(this.getMatchingList());
        this._calleeTableViewer.setInput(this.getCalleeTableInput(this._patternCallee));
        this.setMissingInformation();
    }

    private EMap<InjectedContext, InjectedContext> getMatchingList() {
        EMap parameterMatching = null;
        parameterMatching = this.patternCall.getParameterMatching();
        return parameterMatching;
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this._matchingCommands = new ArrayList<RecordingCommand>();
            this.updatePatternCallee();
            this._callerTableViewer.setInput(this.getCallerTableInput(this._patternCaller));
            this.refreshTables();
            this.checkCreateButtonEnable();
            this.checkEidtAndDeleteButtonEnable();
        }
        super.setVisible(visible);
    }

    private String getPatternName(String name) {
        return String.valueOf(name) + (name == null || name.equals("") ? "" : ":");
    }

    private void setPatternName(Pattern pattern, Label label) {
        String patternName = pattern == null ? "" : pattern.getName();
        label.setText(this.getPatternName(patternName));
    }

    private void updatePatternCallee() {
        this.setPatternName(this._patternCallee, this._patternCalleeNameLabel);
        this._calleeTableViewer.setInput(this.getCallerTableInput(this._patternCallee));
    }

    private void setSelection(TableViewer tableViewer, int oldIndex) {
        int len = tableViewer.getTable().getItemCount();
        if (len > 0) {
            if (oldIndex == len) {
                tableViewer.getTable().setSelection(oldIndex - 1);
            } else if (oldIndex < len) {
                tableViewer.getTable().setSelection(oldIndex);
            }
        }
        this.checkCreateButtonEnable();
        this.checkEidtAndDeleteButtonEnable();
    }

    private void setMissingInformation() {
        String message = null;
        if (this._callerTableViewer.getTable().getItemCount() == 0 || this._calleeTableViewer.getTable().getItemCount() == 0) {
            message = Messages.ParameterMatchingPage_missing_information;
        }
        this.setMessage(message, 1);
    }

    public void setPatternCall(PatternCall call) {
        this.patternCall = call;
    }

    public PatternCall getPatternCall() {
        return this.patternCall;
    }

    public void setPatternCallee(Pattern patternCallee) {
        this._patternCallee = patternCallee;
    }

    public List<RecordingCommand> getParameterMatchingCommands() {
        return this._matchingCommands;
    }
}

