/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.ftask.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.egf.common.helper.StringHelper;
import org.eclipse.egf.model.EGFFtaskPlugin;
import org.eclipse.egf.model.fcore.provider.ActivityItemProvider;
import org.eclipse.egf.model.ftask.FtaskPackage;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemFontProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITableItemColorProvider;
import org.eclipse.emf.edit.provider.ITableItemFontProvider;
import org.eclipse.emf.edit.provider.ITableItemLabelProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskItemProvider
extends ActivityItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
ITableItemLabelProvider,
ITableItemColorProvider,
ITableItemFontProvider,
IItemColorProvider,
IItemFontProvider {
    public TaskItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addKindPropertyDescriptor(object);
            this.addSuperTaskPropertyDescriptor(object);
            this.addImplementationPropertyDescriptor(object);
        }
        return this.itemPropertyDescriptors;
    }

    protected void addKindPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(new ItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Task_kind_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Task_kind_feature", "_UI_Task_type"), (EStructuralFeature)FtaskPackage.Literals.TASK__KIND, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, this.getString("_UI_InfoPropertyCategory"), null){

            public Collection<String> getChoiceOfValues(Object innerObject) {
                List result = EGFFtaskPlugin.getTaskNatureRegistry().getKinds();
                if (!result.contains(null)) {
                    result.add(null);
                }
                return result;
            }
        });
    }

    protected void addImplementationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Task_implementation_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Task_implementation_feature", "_UI_Task_type"), (EStructuralFeature)FtaskPackage.Literals.TASK__IMPLEMENTATION, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, this.getString("_UI_InfoPropertyCategory"), null));
    }

    protected void addSuperTaskPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Task_superTask_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Task_superTask_feature", "_UI_Task_type"), (EStructuralFeature)FtaskPackage.Literals.TASK__SUPER_TASK, true, false, true, null, this.getString("_UI_InfoPropertyCategory"), null));
    }

    public String getText(Object object) {
        Task task = (Task)object;
        String label = task.getName();
        String type = "[" + this.getString("_UI_Task_type");
        if (task.getKindValue() != null && task.getKindValue().trim().length() > 0) {
            type = String.valueOf(type) + " " + StringHelper.toUpperFirst((String)task.getKindValue());
        }
        type = String.valueOf(type) + "]";
        return label == null || label.length() == 0 ? type : String.valueOf(label) + " " + type;
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(Task.class)) {
            case 4: 
            case 6: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), false, true));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public Object getImage(Object object) {
        return this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Task"));
    }

    public String getCreateChildText(Object owner, Object feature, Object child, Collection<?> selection) {
        if (owner instanceof Resource) {
            Task task = (Task)child;
            String label = task.getName();
            String type = this.getString("_UI_Task_type");
            if (task.getKindValue() != null && task.getKindValue().trim().length() > 0) {
                type = String.valueOf(type) + " " + StringHelper.toUpperFirst((String)task.getKindValue());
            }
            return label == null || label.length() == 0 ? type : String.valueOf(label) + " " + type;
        }
        return super.getCreateChildText(owner, feature, child, selection);
    }
}

