/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.java.engine;

import org.eclipse.core.runtime.IPath;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.pattern.common.java.AbstractJavaEngine;
import org.eclipse.egf.pattern.java.engine.JavaAssemblyContentProvider;
import org.eclipse.egf.pattern.java.engine.JavaAssemblyHelper;
import org.eclipse.egf.pattern.java.engine.JavaNatureHelper;
import org.eclipse.egf.pattern.java.engine.JavaTranslationEnhancer;

public class JavaEngine
extends AbstractJavaEngine {
    public JavaEngine(Pattern pattern) throws PatternException {
        super(pattern);
    }

    public void translate() throws PatternException {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            throw new IllegalStateException();
        }
        JavaAssemblyHelper helper = new JavaAssemblyHelper(pattern, new JavaAssemblyContentProvider(pattern));
        String templatecontent = helper.visit();
        JavaTranslationEnhancer enhancer = new JavaTranslationEnhancer(pattern);
        templatecontent = enhancer.enhance(templatecontent);
        try {
            String classname = JavaNatureHelper.getClassName(pattern);
            IPath outputPath = this.computeFilePath(classname);
            this.writeContent(pattern, outputPath, templatecontent);
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
    }

    protected String getPatternClassname() throws PatternException {
        return JavaNatureHelper.getClassName(this.getPattern());
    }
}

