/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributions;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egf.core.ui.contributor.DefaultPropertyEditorContributor;
import org.eclipse.egf.model.domain.DomainPackage;
import org.eclipse.egf.model.domain.WorkspaceDomain;
import org.eclipse.egf.model.editor.contributions.NullableDialogCellEditor;
import org.eclipse.egf.model.editor.l10n.ModelEditorMessages;
import org.eclipse.emf.common.ui.dialogs.WorkspaceResourceDialog;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class WorkspaceDomainEditorContributor
extends DefaultPropertyEditorContributor {
    public boolean canApply(Object object, IItemPropertyDescriptor descriptor) {
        return this.checkFeature(object, descriptor, (EStructuralFeature)DomainPackage.Literals.WORKSPACE_DOMAIN__PATH) && object instanceof WorkspaceDomain;
    }

    public CellEditor createPropertyEditor(Composite composite, Object object, IItemPropertyDescriptor descriptor) {
        final WorkspaceDomain domain = (WorkspaceDomain)object;
        return new NullableDialogCellEditor(composite, this.getLabelProvider(object, descriptor)){

            protected Object openDialogBox(Control control) {
                Object[] initialSelection = null;
                if (domain.getPath() != null) {
                    IFolder folder = ResourcesPlugin.getWorkspace().getRoot().getFolder((IPath)new Path(domain.getPath()));
                    initialSelection = new Object[]{folder};
                }
                String title = ModelEditorMessages.FolderSelectionDialogTitle;
                String message = ModelEditorMessages.FolderSelectionDialogMessage;
                IContainer[] folders = WorkspaceResourceDialog.openFolderSelection((Shell)control.getShell(), (String)title, (String)message, (boolean)false, (Object[])initialSelection, null);
                if (folders.length == 1) {
                    return folders[0].getFullPath().toString();
                }
                return domain.getPath();
            }
        };
    }
}

