/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.jet.engine;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.egf.model.pattern.PatternException;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.pattern.common.java.BaseJavaAssemblyHelper;
import org.eclipse.egf.pattern.jet.Messages;
import org.eclipse.egf.pattern.utils.TemplateFileHelper;

public class JetNatureHelper {
    private static final Pattern compile = Pattern.compile(".*package\\s*=\\s*\"([\\w\\.]*)\".*class\\s*=\\s*\"(\\w*)\".*", 40);

    public static String getTemplateClassName(org.eclipse.egf.model.pattern.Pattern pattern) throws PatternException {
        if (!"JET".equals(pattern.getNature().getName())) {
            throw new PatternException(Messages.bind((String)Messages.assembly_error5, (Object)pattern.getNature().getName()));
        }
        try {
            String content = TemplateFileHelper.getContent((PatternMethod)pattern.getHeaderMethod());
            Matcher matcher = compile.matcher(content);
            if (matcher.matches()) {
                String pack = matcher.group(1);
                String cls = matcher.group(2);
                if ("".equals(pack) || "".equals(cls)) {
                    throw new PatternException(Messages.bind((String)Messages.assembly_error8, (Object)pattern.getName()));
                }
                if ("CLASS".equals(cls) && "PACKAGE".equals(pack)) {
                    return BaseJavaAssemblyHelper.getFullClassName((org.eclipse.egf.model.pattern.Pattern)pattern);
                }
                return String.valueOf(pack) + "." + cls;
            }
        }
        catch (PatternException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PatternException((Throwable)e);
        }
        throw new PatternException(Messages.bind((String)Messages.assembly_error6, (Object)pattern.getName()));
    }

    private JetNatureHelper() {
    }

    public static void main(String[] args) {
        String tmp = "s-2.5";
        String replaceAll = tmp.replaceAll("\\W", "");
        System.out.println(replaceAll);
    }
}

