/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.internal.registry;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryEventListener;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.egf.core.internal.registry.FcoreProcessorProxy;
import org.eclipse.egf.core.processor.IFcoreProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FcoreProcessorRegistry
implements IRegistryEventListener {
    private List<FcoreProcessorProxy> _proxies;
    public static final String EXTENSION_ID = "org.eclipse.egf.core.fcoreProcessor";
    public static final String INVOKER_ATT_CLASS = "class";

    public FcoreProcessorRegistry() {
        this.initialize();
        RegistryFactory.getRegistry().addListener((IRegistryEventListener)this, EXTENSION_ID);
    }

    public List<IFcoreProcessor> getIFcoreProcessors() {
        ArrayList<IFcoreProcessor> loggers = new ArrayList<IFcoreProcessor>();
        for (FcoreProcessorProxy proxy : this._proxies) {
            IFcoreProcessor processor = proxy.getIFcoreProcessor();
            if (processor == null) continue;
            loggers.add(processor);
        }
        return loggers;
    }

    private void initialize() {
        if (this._proxies != null) {
            return;
        }
        this._proxies = new ArrayList<FcoreProcessorProxy>();
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(EXTENSION_ID);
        if (point != null) {
            IExtension[] iExtensionArray = point.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement element = iConfigurationElementArray[n4];
                    this.register(element);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    private void register(IConfigurationElement element) {
        if (element == null) {
            return;
        }
        FcoreProcessorProxy proxy = FcoreProcessorProxy.createProxy(element);
        if (proxy != null) {
            this._proxies.add(proxy);
        }
    }

    public void added(IExtension[] extensions) {
        if (extensions == null) {
            return;
        }
        IExtension[] iExtensionArray = extensions;
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                this.register(element);
                ++n4;
            }
            ++n2;
        }
    }

    public void removed(IExtension[] extensions) {
        int i = 0;
        while (i < extensions.length) {
            Iterator<FcoreProcessorProxy> it = this._proxies.iterator();
            while (it.hasNext()) {
                FcoreProcessorProxy proxy = it.next();
                if (!proxy.originatesFrom(extensions[i])) continue;
                it.remove();
            }
            ++i;
        }
    }

    public void added(IExtensionPoint[] extensionPoints) {
    }

    public void removed(IExtensionPoint[] extensionPoints) {
    }

    public void dispose() {
        RegistryFactory.getRegistry().removeListener((IRegistryEventListener)this);
        this._proxies = null;
    }
}

