/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributions;

import java.util.List;
import org.eclipse.egf.core.ui.contributor.DefaultPropertyEditorContributor;
import org.eclipse.egf.model.editor.l10n.ModelEditorMessages;
import org.eclipse.egf.model.types.TypeURI;
import org.eclipse.egf.model.types.TypesPackage;
import org.eclipse.emf.common.ui.celleditor.ExtendedDialogCellEditor;
import org.eclipse.emf.common.ui.dialogs.ResourceDialog;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class TypeURIEditorContributor
extends DefaultPropertyEditorContributor {
    public boolean canApply(Object object, IItemPropertyDescriptor descriptor) {
        return this.checkFeature(object, descriptor, (EStructuralFeature)TypesPackage.Literals.TYPE_URI__VALUE) && object instanceof TypeURI;
    }

    public CellEditor createPropertyEditor(Composite composite, Object object, IItemPropertyDescriptor descriptor) {
        final TypeURI type = (TypeURI)object;
        return new ExtendedDialogCellEditor(composite, this.getLabelProvider(object, descriptor)){

            protected Object openDialogBox(Control control) {
                ResourceDialog dialog = new ResourceDialog(control.getShell(), ModelEditorMessages.TypeURIEditorContributor_title, 4100){

                    protected Control createDialogArea(Composite parent) {
                        Control innerControl = super.createDialogArea(parent);
                        if (type.getValue() != null) {
                            this.uriField.setText(type.getValue().toString());
                        }
                        return innerControl;
                    }
                };
                if (dialog.open() == 0) {
                    List results = dialog.getURIs();
                    if (results != null && results.size() > 0) {
                        return results.get(0);
                    }
                    return URI.createURI((String)"");
                }
                return type.getValue();
            }

            protected void doSetValue(Object value) {
                if (value != null && "".equals(value.toString())) {
                    super.doSetValue(null);
                } else {
                    super.doSetValue(value);
                }
            }
        };
    }
}

