/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.producer.ui.internal.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.common.l10n.EGFCommonMessages;
import org.eclipse.egf.common.ui.helper.ThrowableHandler;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.RuntimePlatformResourceSet;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.diagnostic.EGFValidator;
import org.eclipse.egf.model.editor.dialogs.ActivitySelectionDialog;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.ftask.Task;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.l10n.ProducerMessages;
import org.eclipse.egf.producer.manager.ActivityManagerProducer;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.egf.producer.ui.EGFProducerUIPlugin;
import org.eclipse.egf.producer.ui.internal.dialogs.ActivityValidationSelectionDialog;
import org.eclipse.egf.producer.ui.l10n.ProducerUIMessages;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.progress.IProgressConstants;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GlobalRunActivityAction
extends Action
implements IWorkbenchWindowActionDelegate,
IActionDelegate2 {
    private Shell _shell;
    private List<Activity> _validates = null;

    public GlobalRunActivityAction() {
        this.setText(ProducerUIMessages.GlobalRunActivityAction_label);
        this.setDescription(ProducerUIMessages.GlobalRunActivityAction_description);
        this.setToolTipText(ProducerUIMessages.GlobalRunActivityAction_tooltip);
        this.setImageDescriptor(EGFProducerUIPlugin.getDefault().getImageDescriptor("elcl16/runactivity.gif"));
    }

    public void run() {
        this.runWithEvent(null);
    }

    public void runWithEvent(Event event) {
        EGFValidator validator;
        Diagnostic validationDiag;
        this._validates = null;
        ActivitySelectionDialog activityDialog = new ActivitySelectionDialog(this._shell, null, false, true);
        activityDialog.setTitle(ProducerUIMessages.GlobalRunActivityAction_dialogTitle);
        int result = activityDialog.open();
        if (result != 0) {
            return;
        }
        Object[] selection = activityDialog.getResult();
        if (selection == null || selection.length != 1) {
            return;
        }
        final Activity[] activity = new Activity[]{(Activity)selection[0]};
        IPreferenceStore store = EGFCoreUIPlugin.getDefault().getPreferenceStore();
        String validate = store.getString("org.eclipse.egf.core.validate.model.instances.before.launch");
        EList activities = activity[0].getActivities();
        int status = this.showValidateDialog((List<Activity>)activities, !validate.equals("never"), validate.equals("prompt"));
        if (status != 0) {
            return;
        }
        if (this._validates != null && this._validates.size() != 0 && (validationDiag = (validator = new EGFValidator(this._validates)).validate()).getSeverity() == 4) {
            return;
        }
        BasicEList tasks = new BasicEList();
        for (Activity innerActivity : activities) {
            if (!(innerActivity instanceof Task)) continue;
            tasks.add((Task)innerActivity);
        }
        WorkspaceJob activityJob = new WorkspaceJob(ProducerUIMessages.GlobalRunActivityAction_label, (List)tasks){
            private final /* synthetic */ List val$tasks;
            {
                this.val$tasks = list;
                super($anonymous0);
            }

            public boolean belongsTo(Object family) {
                return EGFCorePlugin.FAMILY_MANUAL_BUILD.equals(family);
            }

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                ProjectBundleSession session = new ProjectBundleSession(EGFProducerUIPlugin.getDefault().getBundle().getBundleContext());
                IActivityManager activityManager = null;
                SubMonitor subMonitor = null;
                UniqueEList fcores = new UniqueEList();
                for (Resource resource : activity[0].getResources()) {
                    IPlatformFcore fcore;
                    if (!(resource instanceof IPlatformFcoreProvider) || (fcore = ((IPlatformFcoreProvider)resource).getIPlatformFcore()).isRuntime() || fcore.getBundle() != null) continue;
                    if (fcore.isWorkspace()) {
                        fcores.add(fcore);
                        continue;
                    }
                    throw new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.TargetPlatform_ExtensionPoint_no_bundle, (Object)fcore.getPlatformBundle().getBundleId()), null));
                }
                subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NLS.bind((String)EGFCoreMessages.Production_Invoke, (Object)EMFHelper.getText((Object)activity[0])), (int)(100 * fcores.size() + 1000 * this.val$tasks.size()));
                try {
                    for (IPlatformFcore fcore : fcores) {
                        SubMonitor childSubMonitor = subMonitor.newChild(100, 0);
                        childSubMonitor = SubMonitor.convert((IProgressMonitor)childSubMonitor, (String)NLS.bind((String)EGFCoreMessages.Production_Load_Bundle, (Object)fcore.getPlatformBundle().getBundleId()), (int)100);
                        session.getBundle(fcore.getPlatformBundle().getProject());
                    }
                    RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
                    activity[0] = (Activity)resourceSet.getEObject(EcoreUtil.getURI((EObject)activity[0]), true);
                    ActivityManagerProducer producer = EGFProducerPlugin.getActivityManagerProducer((Activity)activity[0]);
                    activityManager = producer.createActivityManager(activity[0]);
                    activityManager.setProjectBundleSession(session);
                    activityManager.initializeContext();
                    final Diagnostic preInvokeDiag = activityManager.canInvoke();
                    if (preInvokeDiag.getSeverity() != 0) {
                        if (EGFProducerUIPlugin.getWorkbenchDisplay() != null) {
                            EGFProducerUIPlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    EGFValidator.handleDiagnostic((String)ProducerUIMessages.ActivityValidationSelectionDialog_Title, (String)ProducerUIMessages._UI_PreInvokeProblems_message, (Diagnostic)preInvokeDiag);
                                }
                            });
                        }
                        if (preInvokeDiag.getSeverity() == 4) {
                            IStatus iStatus = Status.OK_STATUS;
                            return iStatus;
                        }
                    }
                    try {
                        if (EGFProducerUIPlugin.getDefault().isDebugging()) {
                            if (this.val$tasks.size() == 1) {
                                EGFProducerUIPlugin.getDefault().logInfo(NLS.bind((String)ProducerMessages.Activity_Invocation, (Object)EMFHelper.getText((Object)activity)));
                            } else {
                                EGFProducerUIPlugin.getDefault().logInfo(NLS.bind((String)ProducerMessages.Activity_Invocations, (Object)EMFHelper.getText((Object)activity), (Object)this.val$tasks.size()));
                            }
                        }
                        final Diagnostic diagnostic = activityManager.invoke((IProgressMonitor)subMonitor.newChild(1000 * this.val$tasks.size(), 0));
                        if (subMonitor.isCanceled()) {
                            throw new OperationCanceledException();
                        }
                        if (diagnostic != null && diagnostic.getSeverity() != 0 && EGFProducerUIPlugin.getWorkbenchDisplay() != null) {
                            EGFProducerUIPlugin.getWorkbenchDisplay().asyncExec(new Runnable(){

                                public void run() {
                                    EGFValidator.handleDiagnostic((String)ProducerUIMessages.ActivityValidationSelectionDialog_Title, (String)ProducerUIMessages._UI_PostInvokeProblems_message, (Diagnostic)diagnostic);
                                }
                            });
                        }
                    }
                    catch (InvocationException ie) {
                        if (ie.getCause() != null && ie.getCause() instanceof CoreException) {
                            throw (CoreException)ie.getCause();
                        }
                        ThrowableHandler.handleThrowable((String)EGFProducerUIPlugin.getDefault().getPluginID(), (Throwable)ie);
                    }
                    catch (Throwable t) {
                        throw new CoreException(EGFProducerUIPlugin.getDefault().newStatus(4, EGFCommonMessages.Exception_unexpectedException, t));
                    }
                }
                finally {
                    monitor.done();
                    try {
                        if (activityManager != null) {
                            activityManager.dispose();
                        }
                    }
                    catch (Throwable t) {
                        EGFProducerUIPlugin.getDefault().logError(t);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        activityJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        activityJob.setProperty(IProgressConstants.ICON_PROPERTY, (Object)"elcl16/runactivity.gif");
        activityJob.setPriority(30);
        activityJob.setUser(true);
        activityJob.setSystem(false);
        activityJob.schedule();
    }

    private int showValidateDialog(List<Activity> activities, boolean validate, boolean prompt) {
        if (validate) {
            if (prompt && activities != null && activities.size() > 0) {
                ActivityValidationSelectionDialog dialog = new ActivityValidationSelectionDialog(EGFProducerUIPlugin.getActiveWorkbenchShell(), activities);
                if (dialog.open() == 1) {
                    return 1;
                }
                Object[] objects = dialog.getResult();
                this._validates = new ArrayList<Activity>(objects.length);
                int i = 0;
                while (i < objects.length) {
                    this._validates.add((Activity)objects[i]);
                    ++i;
                }
            } else {
                this._validates = activities;
            }
        }
        return 0;
    }

    public void run(IAction action) {
        this.run();
    }

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this._shell = window.getShell();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void runWithEvent(IAction action, Event event) {
        this.runWithEvent(event);
    }

    public void init(IAction action) {
    }
}

