/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.ui;

import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.egf.core.ui.EGFCoreUIPlugin;
import org.eclipse.egf.core.ui.l10n.CoreUIMessages;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class ExceptionHandler {
    private static ExceptionHandler __exceptionHandler = new ExceptionHandler();

    public static void log(Throwable throwable, String message) {
        EGFCoreUIPlugin.getDefault().logError(message, throwable);
    }

    public static void handle(CoreException ce, String title, String message) {
        ExceptionHandler.handle(ce, EGFCoreUIPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(IStatus status, String title, String message) {
        __exceptionHandler.perform(status, EGFCoreUIPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(CoreException ce, Shell parent, String title, String message) {
        __exceptionHandler.perform(ce, parent, title, message);
    }

    public static void handle(InvocationTargetException ce, String title, String message) {
        ExceptionHandler.handle(ce, EGFCoreUIPlugin.getActiveWorkbenchShell(), title, message);
    }

    public static void handle(InvocationTargetException ite, Shell parent, String title, String message) {
        __exceptionHandler.perform(ite, parent, title, message);
    }

    protected void perform(IStatus status, Shell shell, String title, String message) {
        EGFCoreUIPlugin.getDefault().log(status);
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    protected void perform(CoreException e, Shell shell, String title, String message) {
        EGFCoreUIPlugin.getDefault().logError(e);
        IStatus status = e.getStatus();
        if (status != null) {
            ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
        } else {
            this.displayMessageDialog(e.getMessage(), shell, title, message);
        }
    }

    protected void perform(InvocationTargetException e, Shell shell, String title, String message) {
        Throwable target = e.getTargetException();
        if (target instanceof CoreException) {
            this.perform((CoreException)target, shell, title, message);
        } else {
            EGFCoreUIPlugin.getDefault().logError(e);
            if (e.getMessage() != null && e.getMessage().length() > 0) {
                this.displayMessageDialog(e.getMessage(), shell, title, message);
            } else {
                this.displayMessageDialog(target.getMessage(), shell, title, message);
            }
        }
    }

    private void displayMessageDialog(String exceptionMessage, Shell shell, String title, String message) {
        StringWriter msg = new StringWriter();
        if (message != null) {
            msg.write(message);
            msg.write("\n\n");
        }
        if (exceptionMessage == null || exceptionMessage.length() == 0) {
            msg.write(CoreUIMessages.ExceptionDialog_seeErrorLogMessage);
        } else {
            msg.write(exceptionMessage);
        }
        MessageDialog.openError((Shell)shell, (String)title, (String)msg.toString());
    }
}

