/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.editor.contributions;

import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.domain.TypeDomain;
import org.eclipse.egf.model.editor.contributions.OpenEObjectMenuContributor;
import org.eclipse.egf.model.editor.l10n.ModelEditorMessages;
import org.eclipse.egf.model.types.TypeURI;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;

public class OpenURIMenuContributor
extends OpenEObjectMenuContributor {
    public static final String OPEN_URI_ACTION_ID = "open-uri";
    private OpenEObjectMenuContributor.OpenAction _openAction;

    protected String getText() {
        if (this.getOpenAction().isAlreadyOpenedEditor()) {
            return ModelEditorMessages.URIMenuContributor_selectAction_label;
        }
        return ModelEditorMessages.URIMenuContributor_openAction_label;
    }

    protected OpenEObjectMenuContributor.OpenAction getOpenAction() {
        if (this._openAction == null) {
            this._openAction = new URIOpenAction();
        }
        return this._openAction;
    }

    protected class URIOpenAction
    extends OpenEObjectMenuContributor.OpenAction {
        public URIOpenAction() {
            super(OpenURIMenuContributor.this, OpenURIMenuContributor.OPEN_URI_ACTION_ID);
        }

        public boolean isEnabled() {
            return true;
        }

        protected EObject getEObject() {
            if (OpenURIMenuContributor.this._selection == null || OpenURIMenuContributor.this._selection.isEmpty()) {
                return null;
            }
            Object object = ((IStructuredSelection)OpenURIMenuContributor.this._selection).getFirstElement();
            if (object instanceof EMFDomain || object instanceof TypeDomain || object instanceof TypeURI) {
                return (EObject)object;
            }
            return null;
        }

        protected URI getURI() {
            EObject eObject = this.getEObject();
            if (eObject == null) {
                return null;
            }
            URI uri = null;
            if (eObject instanceof EMFDomain) {
                EMFDomain domain = (EMFDomain)eObject;
                uri = domain.getUri();
            } else {
                if (eObject instanceof TypeDomain) {
                    throw new UnsupportedOperationException("TODO");
                }
                if (eObject instanceof TypeURI) {
                    TypeURI typeURI = (TypeURI)eObject;
                    uri = typeURI.getValue();
                }
            }
            return uri;
        }
    }
}

