/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.migrator;

import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.cdo.internal.messages.Messages;
import org.eclipse.emf.codegen.ecore.genmodel.GenDelegationKind;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;

public abstract class CDOMigratorUtil {
    public static final String ROOT_EXTENDS_CLASS = "org.eclipse.emf.internal.cdo.CDOObjectImpl";
    public static final String ROOT_EXTENDS_INTERFACE = "org.eclipse.emf.cdo.CDOObject";
    public static final String PLUGIN_VARIABLE = "CDO=org.eclipse.emf.cdo";

    private CDOMigratorUtil() {
    }

    public static String adjustGenModel(GenModel genModel) {
        return CDOMigratorUtil.adjustGenModel(genModel, GenDelegationKind.REFLECTIVE_LITERAL);
    }

    public static String adjustGenModel(GenModel genModel, GenDelegationKind featureDelegation) {
        IWorkspaceRoot root;
        IFolder modelFolder;
        IProject modelProject;
        EList pluginVariables;
        StringBuilder builder = new StringBuilder();
        if (genModel.getFeatureDelegation() != featureDelegation) {
            genModel.setFeatureDelegation(featureDelegation);
            builder.append(Messages.getString("CDOMigrator.4"));
            builder.append(featureDelegation);
            builder.append("\n");
        }
        if (!ROOT_EXTENDS_CLASS.equals(genModel.getRootExtendsClass())) {
            genModel.setRootExtendsClass(ROOT_EXTENDS_CLASS);
            builder.append(Messages.getString("CDOMigrator.6"));
            builder.append(ROOT_EXTENDS_CLASS);
            builder.append("\n");
        }
        if (!ROOT_EXTENDS_INTERFACE.equals(genModel.getRootExtendsInterface())) {
            genModel.setRootExtendsInterface(ROOT_EXTENDS_INTERFACE);
            builder.append(Messages.getString("CDOMigrator.8"));
            builder.append(ROOT_EXTENDS_INTERFACE);
            builder.append("\n");
        }
        if (!(pluginVariables = genModel.getModelPluginVariables()).contains((Object)PLUGIN_VARIABLE)) {
            pluginVariables.add((Object)PLUGIN_VARIABLE);
            builder.append(Messages.getString("CDOMigrator.10"));
            builder.append(PLUGIN_VARIABLE);
            builder.append("\n");
        }
        if (!(modelProject = (modelFolder = (root = ResourcesPlugin.getWorkspace().getRoot()).getFolder((IPath)new Path(genModel.getModelDirectory()))).getProject()).exists()) {
            try {
                modelProject.create((IProgressMonitor)new NullProgressMonitor());
                builder.append(String.valueOf(Messages.getString("CDOMigrator.12")) + "\n");
            }
            catch (CoreException ex) {
                throw new WrappedException((Exception)((Object)ex));
            }
        }
        if (!modelProject.isOpen()) {
            try {
                modelProject.open((IProgressMonitor)new NullProgressMonitor());
                builder.append(String.valueOf(Messages.getString("CDOMigrator.13")) + "\n");
            }
            catch (CoreException ex) {
                throw new WrappedException((Exception)((Object)ex));
            }
        }
        return builder.length() == 0 ? null : builder.toString();
    }
}

