/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.application.internal.activity;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.application.internal.activator.EGFApplicationPlugin;
import org.eclipse.egf.application.internal.l10n.ApplicationMessages;
import org.eclipse.egf.common.helper.EMFHelper;
import org.eclipse.egf.core.domain.RuntimePlatformResourceSet;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.fcore.IPlatformFcoreProvider;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.egf.core.producer.InvocationException;
import org.eclipse.egf.core.session.ProjectBundleSession;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.producer.EGFProducerPlugin;
import org.eclipse.egf.producer.l10n.ProducerMessages;
import org.eclipse.egf.producer.manager.IActivityManager;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticException;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActivityRunner {
    protected List<Activity> _activities;

    public ActivityRunner(Activity activity) {
        if (activity != null) {
            this._activities = Collections.singletonList(activity);
        }
    }

    public ActivityRunner(List<Activity> activities) {
        this._activities = activities;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (this._activities == null || this._activities.isEmpty()) {
            return;
        }
        ProjectBundleSession session = new ProjectBundleSession(EGFApplicationPlugin.getDefault().getBundle().getBundleContext());
        RuntimePlatformResourceSet resourceSet = new RuntimePlatformResourceSet();
        try {
            SubMonitor childSubMonitor;
            UniqueEList workspaceFcores = new UniqueEList();
            for (Activity activity : this._activities) {
                for (Resource resource : activity.getResources()) {
                    IPlatformFcore fcore;
                    if (!(resource instanceof IPlatformFcoreProvider) || (fcore = ((IPlatformFcoreProvider)resource).getIPlatformFcore()).isRuntime() || fcore.getBundle() != null) continue;
                    if (fcore.isWorkspace()) {
                        workspaceFcores.add(fcore);
                        continue;
                    }
                    throw new CoreException(EGFProducerPlugin.getDefault().newStatus(4, NLS.bind((String)EGFCoreMessages.TargetPlatform_ExtensionPoint_no_bundle, (Object)fcore.getPlatformBundle().getBundleId()), null));
                }
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)ApplicationMessages.ActivityRunner_Run, (int)(100 * workspaceFcores.size() + this._activities.size() * 1000));
            for (IPlatformFcore workspaceFcore : workspaceFcores) {
                childSubMonitor = subMonitor.newChild(100, 0);
                childSubMonitor = SubMonitor.convert((IProgressMonitor)childSubMonitor, (String)NLS.bind((String)EGFCoreMessages.Production_Load_Bundle, (Object)workspaceFcore.getPlatformBundle().getBundleId()), (int)100);
                try {
                    session.getBundle(workspaceFcore.getPlatformBundle().getProject());
                }
                catch (Throwable t) {
                    if (t instanceof CoreException) {
                        throw (CoreException)t;
                    }
                    throw new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityRunner_Exception, (Object)workspaceFcore.getPlatformBundle().getBundleId()), t));
                }
            }
            for (Activity activity : this._activities) {
                Diagnostic diagnostic;
                childSubMonitor = subMonitor.newChild(1000, 0);
                childSubMonitor = SubMonitor.convert((IProgressMonitor)childSubMonitor, (String)NLS.bind((String)EGFCoreMessages.Production_Invoke, (Object)EMFHelper.getText((Object)activity)), (int)1000);
                IActivityManager manager = null;
                try {
                    activity = (Activity)resourceSet.getEObject(EcoreUtil.getURI((EObject)activity), true);
                }
                catch (Throwable t) {
                    throw new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityRunner_Exception, (Object)EcoreUtil.getURI((EObject)activity)), t));
                }
                try {
                    manager = EGFProducerPlugin.getActivityManagerProducer((Activity)activity).createActivityManager(activity);
                    manager.setProjectBundleSession(session);
                    manager.initializeContext();
                }
                catch (Throwable t) {
                    if (t instanceof CoreException) {
                        throw (CoreException)t;
                    }
                    throw new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityRunner_Exception, (Object)EcoreUtil.getURI((EObject)activity)), t));
                }
                try {
                    diagnostic = manager.canInvoke();
                    if (diagnostic.getSeverity() == 4) {
                        throw DiagnosticException.toCoreException((DiagnosticException)new DiagnosticException(diagnostic));
                    }
                }
                catch (CoreException ce) {
                    throw ce;
                }
                catch (InvocationException ie) {
                    throw new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityRunner_PreInvokeProblems_message, (Object)EcoreUtil.getURI((EObject)activity)), ie));
                }
                diagnostic = null;
                try {
                    int ticks = manager.getSteps();
                    if (ticks == 1) {
                        EGFApplicationPlugin.getDefault().logInfo(NLS.bind((String)ProducerMessages.Activity_Invocation, (Object)EMFHelper.getText((Object)activity)));
                    } else {
                        EGFApplicationPlugin.getDefault().logInfo(NLS.bind((String)ProducerMessages.Activity_Invocations, (Object)EMFHelper.getText((Object)activity), (Object)ticks));
                    }
                    diagnostic = manager.invoke((IProgressMonitor)childSubMonitor.newChild(1000 * ticks, 0));
                }
                catch (Throwable t) {
                    throw new CoreException(EGFApplicationPlugin.getDefault().newStatus(4, NLS.bind((String)ApplicationMessages.ActivityRunner_Exception, (Object)EcoreUtil.getURI((EObject)activity)), t));
                }
                if (diagnostic.getSeverity() != 4) continue;
                throw DiagnosticException.toCoreException((DiagnosticException)new DiagnosticException(diagnostic));
            }
        }
        finally {
            session.dispose();
            monitor.done();
        }
    }
}

