/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.domain;

import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistoryListener;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryEvent;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.egf.core.l10n.EGFCoreMessages;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.transaction.NotificationFilter;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomainEvent;
import org.eclipse.emf.transaction.TransactionalEditingDomainListener;
import org.eclipse.emf.transaction.TransactionalEditingDomainListenerImpl;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.workspace.IWorkspaceCommandStack;
import org.eclipse.emf.workspace.ResourceUndoContext;
import org.eclipse.osgi.util.NLS;

public class ResourceModificationManager {
    private static Map<TransactionalEditingDomain, WeakReference<ResourceModificationManager>> managerRegistry = new WeakHashMap<TransactionalEditingDomain, WeakReference<ResourceModificationManager>>();
    private static final NotificationFilter RESOURCE_UNMODIFIED = new NotificationFilter.Custom(){

        public boolean matches(Notification notification) {
            return notification.getNotifier() instanceof Resource && notification.getFeatureID(Resource.class) == 3 && notification.getOldBooleanValue() && !notification.getNewBooleanValue();
        }
    };
    private TransactionalEditingDomain domain;
    private IOperationHistory history;
    private ResourceSetListener domainListener;
    private IOperationHistoryListener historyListener;
    private Map<Resource, IUndoContext> saveContexts;
    private IUndoableOperation currentOperation;

    public static synchronized ResourceModificationManager manage(TransactionalEditingDomain domain) {
        IOperationHistory history;
        CommandStack stack;
        ResourceModificationManager result;
        WeakReference<ResourceModificationManager> reference = managerRegistry.get(domain);
        ResourceModificationManager resourceModificationManager = result = reference != null ? (ResourceModificationManager)reference.get() : null;
        if (result == null && (stack = domain.getCommandStack()) instanceof IWorkspaceCommandStack && (history = ((IWorkspaceCommandStack)stack).getOperationHistory()) != null) {
            final ResourceModificationManager manager = new ResourceModificationManager(domain, history);
            managerRegistry.put(domain, new WeakReference<ResourceModificationManager>(manager));
            result = manager;
            TransactionalEditingDomain.Lifecycle lifecycle = (TransactionalEditingDomain.Lifecycle)TransactionUtil.getAdapter((TransactionalEditingDomain)domain, TransactionalEditingDomain.Lifecycle.class);
            if (lifecycle != null) {
                lifecycle.addTransactionalEditingDomainListener((TransactionalEditingDomainListener)new TransactionalEditingDomainListenerImpl(){

                    public void editingDomainDisposing(TransactionalEditingDomainEvent event) {
                        manager.dispose();
                    }
                });
            }
        }
        return result;
    }

    private ResourceModificationManager(TransactionalEditingDomain domain, IOperationHistory history) {
        this.domain = domain;
        this.history = history;
        domain.addResourceSetListener(this.getDomainListener());
        history.addOperationHistoryListener(this.getHistoryListener());
    }

    private ResourceSetListener getDomainListener() {
        if (this.domainListener == null) {
            this.domainListener = new ResourceSetListenerImpl(RESOURCE_UNMODIFIED.or(NotificationFilter.RESOURCE_UNLOADED)){

                public void resourceSetChanged(ResourceSetChangeEvent event) {
                    for (Notification n : event.getNotifications()) {
                        Resource resource = (Resource)n.getNotifier();
                        switch (n.getFeatureID(Resource.class)) {
                            case 3: {
                                ResourceModificationManager.this.applySaveContext(resource);
                                break;
                            }
                            case 4: {
                                ResourceModificationManager.this.disposeSaveContext(resource);
                            }
                        }
                    }
                }

                public boolean isPostcommitOnly() {
                    return true;
                }
            };
        }
        return this.domainListener;
    }

    private IOperationHistoryListener getHistoryListener() {
        if (this.historyListener == null) {
            this.historyListener = new IOperationHistoryListener(){

                public void historyNotification(OperationHistoryEvent event) {
                    int type = event.getEventType();
                    switch (type) {
                        case 1: 
                        case 2: 
                        case 3: {
                            ResourceModificationManager.this.currentOperation = event.getOperation();
                            break;
                        }
                        case 7: {
                            ResourceModificationManager.this.currentOperation = null;
                            break;
                        }
                        case 4: {
                            ResourceModificationManager.this.currentOperation = null;
                            IUndoableOperation operation = event.getOperation();
                            Set affectedResources = ResourceModificationManager.this.getAffectedResourcesInDomain(operation);
                            for (Resource r : affectedResources) {
                                ResourceUndoContext context = new ResourceUndoContext(ResourceModificationManager.this.domain, r);
                                IUndoableOperation[] undoHistory = ResourceModificationManager.this.history.getUndoHistory((IUndoContext)context);
                                if (undoHistory.length < ResourceModificationManager.this.history.getLimit((IUndoContext)context)) continue;
                                ResourceModificationManager.this.getSaveContext(r);
                            }
                            break;
                        }
                        case 9: 
                        case 10: {
                            ResourceModificationManager.this.currentOperation = null;
                            IUndoableOperation operation = event.getOperation();
                            Set affectedResources = ResourceModificationManager.this.getAffectedResourcesInDomain(operation);
                            for (Resource r : affectedResources) {
                                boolean atSaveContext;
                                IUndoContext saveContext = (IUndoContext)ResourceModificationManager.this.getSaveContexts().get(r);
                                IUndoableOperation nextUndoableOperation = ResourceModificationManager.this.getNextUndoableOperation(r);
                                boolean atStart = saveContext == null && nextUndoableOperation == null;
                                boolean bl = atSaveContext = saveContext != null && nextUndoableOperation != null && nextUndoableOperation.hasContext(saveContext);
                                if (!atStart && !atSaveContext) continue;
                                r.setModified(false);
                            }
                            break;
                        }
                    }
                }
            };
        }
        return this.historyListener;
    }

    private Map<Resource, IUndoContext> getSaveContexts() {
        if (this.saveContexts == null) {
            this.saveContexts = new HashMap<Resource, IUndoContext>();
        }
        return this.saveContexts;
    }

    private IUndoableOperation getNextUndoableOperation(Resource resource) {
        return this.history.getUndoOperation((IUndoContext)new ResourceUndoContext(this.domain, resource));
    }

    private IUndoContext getSaveContext(final Resource resource) {
        Object saveContext = this.getSaveContexts().get(resource);
        if (saveContext == null) {
            saveContext = new UndoContext(){

                public String getLabel() {
                    return NLS.bind((String)EGFCoreMessages.saveContextLabel, (Object)resource.getURI());
                }

                public String toString() {
                    return this.getLabel();
                }
            };
            this.getSaveContexts().put(resource, (IUndoContext)saveContext);
        }
        return saveContext;
    }

    private Set<Resource> getAffectedResourcesInDomain(IUndoableOperation operation) {
        HashSet<Resource> result = new HashSet<Resource>();
        Set affectedResources = ResourceUndoContext.getAffectedResources((IUndoableOperation)operation);
        for (Resource resource : affectedResources) {
            ResourceSet resourceSet = resource.getResourceSet();
            if (!this.domain.getResourceSet().equals(resourceSet)) continue;
            result.add(resource);
        }
        return result;
    }

    private void applySaveContext(Resource resource) {
        IUndoContext saveContext = this.getSaveContexts().get(resource);
        if (saveContext != null) {
            IUndoableOperation[] redoableOperations;
            IUndoableOperation[] undoableOperations;
            IUndoableOperation[] iUndoableOperationArray = undoableOperations = this.history.getUndoHistory(saveContext);
            int n = undoableOperations.length;
            int n2 = 0;
            while (n2 < n) {
                IUndoableOperation op = iUndoableOperationArray[n2];
                op.removeContext(saveContext);
                ++n2;
            }
            IUndoableOperation[] iUndoableOperationArray2 = redoableOperations = this.history.getRedoHistory(saveContext);
            int n3 = redoableOperations.length;
            n = 0;
            while (n < n3) {
                IUndoableOperation op = iUndoableOperationArray2[n];
                op.removeContext(saveContext);
                ++n;
            }
        }
        IUndoableOperation operation = null;
        IUndoableOperation nextUndoable = this.getNextUndoableOperation(resource);
        if (this.currentOperation != null) {
            if (this.currentOperation == nextUndoable) {
                IUndoableOperation[] undoableOperations = this.history.getUndoHistory((IUndoContext)new ResourceUndoContext(this.domain, resource));
                int i = undoableOperations.length - 1;
                while (i >= 0) {
                    if (this.currentOperation != undoableOperations[i]) {
                        operation = undoableOperations[i];
                        break;
                    }
                    --i;
                }
            } else {
                operation = this.currentOperation;
            }
        } else {
            operation = nextUndoable;
        }
        if (operation != null) {
            operation.addContext(this.getSaveContext(resource));
        } else {
            this.getSaveContexts().remove(resource);
        }
    }

    private void disposeSaveContext(Resource resource) {
        IUndoContext saveContext = this.getSaveContexts().get(resource);
        if (saveContext != null) {
            this.history.dispose(saveContext, true, true, true);
            this.getSaveContexts().remove(resource);
        }
    }

    private void dispose() {
        managerRegistry.remove(this.domain);
        if (this.saveContexts != null) {
            for (Resource r : this.saveContexts.keySet()) {
                this.disposeSaveContext(r);
            }
        }
        if (this.domainListener != null) {
            this.domain.removeResourceSetListener(this.domainListener);
        }
        if (this.historyListener != null) {
            this.history.removeOperationHistoryListener(this.historyListener);
        }
        this.currentOperation = null;
        this.domain = null;
        this.domainListener = null;
        this.history = null;
        this.historyListener = null;
        this.saveContexts = null;
    }
}

