/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.model.types.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.common.helper.ClassHelper;
import org.eclipse.egf.common.helper.FileHelper;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.model.EGFModelPlugin;
import org.eclipse.egf.model.helper.ValidationHelper;
import org.eclipse.egf.model.types.Type;
import org.eclipse.egf.model.types.TypeAbstractClass;
import org.eclipse.egf.model.types.TypeBigDecimal;
import org.eclipse.egf.model.types.TypeBigInteger;
import org.eclipse.egf.model.types.TypeBoolean;
import org.eclipse.egf.model.types.TypeByte;
import org.eclipse.egf.model.types.TypeCharacter;
import org.eclipse.egf.model.types.TypeClass;
import org.eclipse.egf.model.types.TypeCollection;
import org.eclipse.egf.model.types.TypeDate;
import org.eclipse.egf.model.types.TypeDouble;
import org.eclipse.egf.model.types.TypeElement;
import org.eclipse.egf.model.types.TypeFloat;
import org.eclipse.egf.model.types.TypeInteger;
import org.eclipse.egf.model.types.TypeList;
import org.eclipse.egf.model.types.TypeLong;
import org.eclipse.egf.model.types.TypeMap;
import org.eclipse.egf.model.types.TypeObject;
import org.eclipse.egf.model.types.TypeSet;
import org.eclipse.egf.model.types.TypeShort;
import org.eclipse.egf.model.types.TypeString;
import org.eclipse.egf.model.types.TypeURI;
import org.eclipse.egf.model.types.TypesException;
import org.eclipse.egf.model.types.TypesPackage;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.validation.model.EvaluationMode;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.service.IBatchValidator;
import org.eclipse.emf.validation.service.ITraversalStrategy;
import org.eclipse.emf.validation.service.ModelValidationService;
import org.eclipse.osgi.util.NLS;

public class TypesValidator
extends EObjectValidator {
    public static final TypesValidator INSTANCE = new TypesValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.egf.model.types";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    private final IBatchValidator batchValidator = (IBatchValidator)ModelValidationService.getInstance().newValidator(EvaluationMode.BATCH);

    public TypesValidator() {
        this.batchValidator.setTraversalStrategy((ITraversalStrategy)new ITraversalStrategy.Recursive());
        this.batchValidator.setIncludeLiveConstraints(true);
        this.batchValidator.setReportSuccesses(false);
    }

    protected EPackage getEPackage() {
        return TypesPackage.eINSTANCE;
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        IStatus status = Status.OK_STATUS;
        super.validate(eClass, eObject, diagnostics, context);
        if (diagnostics != null && !this.hasProcessed(eObject, context)) {
            status = this.batchValidator.validate(eObject, (IProgressMonitor)new NullProgressMonitor());
            this.processed(eObject, context, status);
            this.appendDiagnostics(status, diagnostics);
        }
        return status.isOK();
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validateTypeElement((TypeElement)value, diagnostics, context);
            }
            case 1: {
                return this.validateType((Type)value, diagnostics, context);
            }
            case 2: {
                return this.validateTypeObject((TypeObject)value, diagnostics, context);
            }
            case 3: {
                return this.validateTypeAbstractClass((TypeAbstractClass)value, diagnostics, context);
            }
            case 4: {
                return this.validateTypeClass((TypeClass)value, diagnostics, context);
            }
            case 5: {
                return this.validateTypeCollection((TypeCollection)value, diagnostics, context);
            }
            case 6: {
                return this.validateTypeList((TypeList)value, diagnostics, context);
            }
            case 7: {
                return this.validateTypeSet((TypeSet)value, diagnostics, context);
            }
            case 8: {
                return this.validateTypeMap((TypeMap)value, diagnostics, context);
            }
            case 9: {
                return this.validateTypeBigDecimal((TypeBigDecimal)value, diagnostics, context);
            }
            case 10: {
                return this.validateTypeBigInteger((TypeBigInteger)value, diagnostics, context);
            }
            case 11: {
                return this.validateTypeBoolean((TypeBoolean)value, diagnostics, context);
            }
            case 12: {
                return this.validateTypeByte((TypeByte)value, diagnostics, context);
            }
            case 13: {
                return this.validateTypeCharacter((TypeCharacter)value, diagnostics, context);
            }
            case 14: {
                return this.validateTypeDate((TypeDate)value, diagnostics, context);
            }
            case 15: {
                return this.validateTypeDouble((TypeDouble)value, diagnostics, context);
            }
            case 16: {
                return this.validateTypeFloat((TypeFloat)value, diagnostics, context);
            }
            case 17: {
                return this.validateTypeInteger((TypeInteger)value, diagnostics, context);
            }
            case 18: {
                return this.validateTypeLong((TypeLong)value, diagnostics, context);
            }
            case 19: {
                return this.validateTypeShort((TypeShort)value, diagnostics, context);
            }
            case 20: {
                return this.validateTypeString((TypeString)value, diagnostics, context);
            }
            case 21: {
                return this.validateTypeURI((TypeURI)value, diagnostics, context);
            }
            case 22: {
                return this.validateSet((Set)value, diagnostics, context);
            }
            case 23: {
                return this.validateList((List)value, diagnostics, context);
            }
            case 24: {
                return this.validateCollection((Collection)value, diagnostics, context);
            }
            case 25: {
                return this.validateURI((URI)value, diagnostics, context);
            }
            case 26: {
                return this.validateTypesException((TypesException)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateTypeElement(TypeElement typeElement, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(typeElement, diagnostics, context);
    }

    public boolean validateType(Type type, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(type, diagnostics, context);
    }

    public boolean validateTypeObject(TypeObject typeObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeObject, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeObject, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeObject, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeObject, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeObject_ValidValue(TypeObject typeObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (typeObject.getValue() == null || context == null || context.get("org.eclipse.egf.core.model.validate.types") == Boolean.FALSE) {
            return true;
        }
        if (!ValidationHelper.isValidClass(typeObject, typeObject.getType(), typeObject.getValue().getClass().getName(), context)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidValue", TypesValidator.getObjectLabel((EObject)typeObject, context), NLS.bind((String)"Type mismatch ''{0}'' with ''{1}''", (Object)typeObject.getType().getClass().getName(), (Object)typeObject.getValue().getClass().getName())}, new Object[]{typeObject}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTypeAbstractClass(TypeAbstractClass typeAbstractClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeAbstractClass, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeAbstractClass, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeAbstractClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeAbstractClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeAbstractClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeAbstractClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeAbstractClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeAbstractClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_LoadableType(typeAbstractClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidValue(typeAbstractClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidInstance(typeAbstractClass, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeAbstractClass_LoadableType(TypeAbstractClass typeAbstractClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (typeAbstractClass.getValue() == null) {
            return true;
        }
        if (!ValidationHelper.isLoadableClass(typeAbstractClass, typeAbstractClass.getValue(), context)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"LoadableType", TypesValidator.getObjectLabel((EObject)typeAbstractClass, context), NLS.bind((String)"Unable to load Value ''{0}''", (Object)typeAbstractClass.getValue())}, new Object[]{typeAbstractClass}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTypeAbstractClass_ValidValue(TypeAbstractClass typeAbstractClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (typeAbstractClass.getValue() == null || context == null || context.get("org.eclipse.egf.core.model.validate.types") == Boolean.FALSE) {
            return true;
        }
        if (typeAbstractClass instanceof TypeClass) {
            return true;
        }
        if (!ValidationHelper.isValidClass(typeAbstractClass, typeAbstractClass.getType(), typeAbstractClass.getValue(), context)) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidValue", TypesValidator.getObjectLabel((EObject)typeAbstractClass, context), NLS.bind((String)"Type and Value mismatch ''{0}'' with ''{1}''", (Object)typeAbstractClass.getType().getName(), (Object)typeAbstractClass.getValue())}, new Object[]{typeAbstractClass}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTypeAbstractClass_ValidInstance(TypeAbstractClass typeAbstractClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (typeAbstractClass.getInstance() == null || typeAbstractClass.getValue() == null) {
            return true;
        }
        if (!ClassHelper.isSubClass(typeAbstractClass.getInstance().getClass(), typeAbstractClass.getType())) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidInstance", TypesValidator.getObjectLabel((EObject)typeAbstractClass, context), NLS.bind((String)"Type and Instance mismatch ''{0}'' with ''{1}''", (Object)typeAbstractClass.getType().getName(), (Object)typeAbstractClass.getInstance().getClass().getName())}, new Object[]{typeAbstractClass}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTypeCollection(TypeCollection typeCollection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeCollection, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeCollection, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_LoadableType(typeCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidValue(typeCollection, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidInstance(typeCollection, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeList(TypeList typeList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeList, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeList, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeList, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeList, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeList, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeList, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeList, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeList, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_LoadableType(typeList, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidValue(typeList, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidInstance(typeList, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeSet(TypeSet typeSet, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeSet, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeSet, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_LoadableType(typeSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidValue(typeSet, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidInstance(typeSet, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeClass(TypeClass typeClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeClass, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeClass, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_LoadableType(typeClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidValue(typeClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidInstance(typeClass, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeClass_MandatoryValue(typeClass, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeClass_MandatoryValue(TypeClass typeClass, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (typeClass.getValue() == null || typeClass.getValue().trim().length() == 0) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"MandatoryValue", TypesValidator.getObjectLabel((EObject)typeClass, context), "The attribute value is mandatory"}, new Object[]{typeClass}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateTypeMap(TypeMap typeMap, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeMap, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeMap, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_LoadableType(typeMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidValue(typeMap, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeAbstractClass_ValidInstance(typeMap, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeBigDecimal(TypeBigDecimal typeBigDecimal, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeBigDecimal, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeBigDecimal, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeBigDecimal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeBigDecimal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeBigDecimal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeBigDecimal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeBigDecimal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeBigDecimal, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeBigDecimal, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeBigInteger(TypeBigInteger typeBigInteger, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeBigInteger, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeBigInteger, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeBigInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeBigInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeBigInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeBigInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeBigInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeBigInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeBigInteger, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeBoolean(TypeBoolean typeBoolean, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeBoolean, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeBoolean, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeBoolean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeBoolean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeBoolean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeBoolean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeBoolean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeBoolean, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeBoolean, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeByte(TypeByte typeByte, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeByte, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeByte, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeByte, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeByte, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeByte, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeByte, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeByte, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeByte, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeByte, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeCharacter(TypeCharacter typeCharacter, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeCharacter, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeCharacter, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeCharacter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeCharacter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeCharacter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeCharacter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeCharacter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeCharacter, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeCharacter, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeDate(TypeDate typeDate, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeDate, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeDate, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeDate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeDate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeDate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeDate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeDate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeDate, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeDate, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeDouble(TypeDouble typeDouble, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeDouble, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeDouble, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeDouble, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeDouble, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeDouble, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeDouble, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeDouble, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeDouble, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeDouble, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeFloat(TypeFloat typeFloat, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeFloat, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeFloat, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeFloat, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeFloat, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeFloat, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeFloat, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeFloat, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeFloat, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeFloat, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeInteger(TypeInteger typeInteger, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeInteger, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeInteger, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeInteger, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeInteger, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeLong(TypeLong typeLong, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeLong, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeLong, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeLong, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeLong, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeLong, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeLong, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeLong, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeLong, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeLong, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeShort(TypeShort typeShort, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeShort, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeShort, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeShort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeShort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeShort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeShort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeShort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeShort, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeShort, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeString(TypeString typeString, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeString, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeString, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeString, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeString, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeString, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeString, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeString, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeString, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeString, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeURI(TypeURI typeURI, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!this.validate_NoCircularContainment(typeURI, diagnostics, context)) {
            return false;
        }
        boolean result = this.validate_EveryMultiplicityConforms(typeURI, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validate_EveryDataValueConforms(typeURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryReferenceIsContained(typeURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryProxyResolves(typeURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_UniqueID(typeURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryKeyUnique(typeURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validate_EveryMapEntryUnique(typeURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeObject_ValidValue(typeURI, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateTypeURI_ValidURI(typeURI, diagnostics, context);
        }
        return result;
    }

    public boolean validateTypeURI_ValidURI(TypeURI typeURI, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (typeURI.getValue() == null) {
            return true;
        }
        URI uri = typeURI.getValue();
        boolean valid = true;
        InputStream inputStream = null;
        try {
            inputStream = EGFPlatformPlugin.getPlatformURIConverter().createInputStream(uri);
        }
        catch (IOException exception) {
            valid = false;
        }
        FileHelper.safeClose((InputStream)inputStream);
        if (!valid) {
            if (diagnostics != null) {
                diagnostics.add((Diagnostic)this.createDiagnostic(4, DIAGNOSTIC_SOURCE, 0, "_UI_EGFConstraint_diagnostic", new Object[]{"ValidURI", TypesValidator.getObjectLabel((EObject)typeURI, context), NLS.bind((String)"Unable to load URI ''{0}''", (Object)uri)}, new Object[]{typeURI}, context));
            }
            return false;
        }
        return true;
    }

    public boolean validateURI(URI uri, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateTypesException(TypesException typesException, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateCollection(Collection<?> collection, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateList(List<?> list, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateSet(Set<?> set, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public ResourceLocator getResourceLocator() {
        return EGFModelPlugin.INSTANCE;
    }

    private void processed(EObject eObject, Map<Object, Object> context, IStatus status) {
        if (context != null) {
            context.put(eObject, status);
        }
    }

    private boolean hasProcessed(EObject eObject, Map<Object, Object> context) {
        boolean result = false;
        if (context != null) {
            while (eObject != null) {
                if (context.containsKey(eObject)) {
                    result = true;
                    eObject = null;
                    continue;
                }
                eObject = eObject.eContainer();
            }
        }
        return result;
    }

    private void appendDiagnostics(IStatus status, DiagnosticChain diagnostics) {
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (i < children.length) {
                this.appendDiagnostics(children[i], diagnostics);
                ++i;
            }
        } else if (status instanceof IConstraintStatus) {
            diagnostics.add((Diagnostic)new BasicDiagnostic(status.getSeverity(), status.getPlugin(), status.getCode(), status.getMessage(), ((IConstraintStatus)status).getResultLocus().toArray()));
        }
    }
}

