/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.domain.EgfResourceSet;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.model.fcore.NamedModelElement;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternElement;
import org.eclipse.egf.model.pattern.PatternLibrary;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.PatternParameter;
import org.eclipse.egf.pattern.EGFPatternPlugin;
import org.eclipse.egf.pattern.collector.PatternCollector;
import org.eclipse.egf.pattern.collector.PatternElementCollector;
import org.eclipse.egf.pattern.collector.PatternLibraryCollector;
import org.eclipse.egf.pattern.extension.PatternFactory;
import org.eclipse.egf.pattern.l10n.EGFPatternMessages;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;

public class PatternHelper {
    private final ResourceSet resourceSet;
    public static final PatternHelper TRANSACTIONNAL_COLLECTOR = new PatternHelper(TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID));

    public static String getFullLibraryName(Pattern pattern) {
        return pattern.getContainer().getName();
    }

    public static String getFactoryComponentName(PatternLibrary library) {
        return library.getPatternViewpoint().getViewpointContainer().getFactoryComponent().getName();
    }

    public static String getFactoryComponentName(Pattern pattern) {
        return PatternHelper.getFactoryComponentName(pattern.getContainer());
    }

    public Pattern getPattern(String id) {
        for (Pattern p : this.getAllPatterns()) {
            if (!p.getID().equals(id)) continue;
            return p;
        }
        return null;
    }

    public List<Pattern> getPatterns(URI uri) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        this.collectPatterns(uri, PatternCollector.EMPTY_ID_SET, result);
        return result;
    }

    public Map<String, PatternElement> getPatternElements(Set<String> ids) {
        IPlatformFcore[] platformFcores;
        ArrayList result = new ArrayList(200);
        IPlatformFcore[] iPlatformFcoreArray = platformFcores = EGFCorePlugin.getPlatformFcores();
        int n = platformFcores.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore platformFcore = iPlatformFcoreArray[n2];
            URI uri = platformFcore.getURI();
            try {
                Resource res = this.resourceSet.getResource(uri, true);
                PatternElementCollector.INSTANCE.collect((List<EObject>)res.getContents(), result, ids);
            }
            catch (Exception e) {
                EGFPatternPlugin.getDefault().logError(NLS.bind((String)EGFPatternMessages.collect_error2, (Object)uri.toString()), e);
            }
            ++n2;
        }
        HashMap<String, PatternElement> map = new HashMap<String, PatternElement>(200);
        for (PatternElement pe : result) {
            map.put(pe.getID(), pe);
        }
        return map;
    }

    public List<Pattern> getPatterns(IProject project, Set<String> ids) {
        IPlatformFcore[] platformFcores;
        if (ids == null) {
            ids = new HashSet<String>();
        }
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        IPlatformFcore[] iPlatformFcoreArray = platformFcores = EGFCorePlugin.getWorkspacePlatformFcores((IProject)project);
        int n = platformFcores.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore platformFcore = iPlatformFcoreArray[n2];
            this.collectPatterns(platformFcore.getURI(), ids, result);
            ++n2;
        }
        return result;
    }

    public List<Pattern> getAllPatterns() {
        IPlatformFcore[] platformFcores;
        ArrayList<Pattern> result = new ArrayList<Pattern>(200);
        IPlatformFcore[] iPlatformFcoreArray = platformFcores = EGFCorePlugin.getPlatformFcores();
        int n = platformFcores.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore platformFcore = iPlatformFcoreArray[n2];
            URI uri = platformFcore.getURI();
            try {
                this.collectPatterns(uri, PatternCollector.EMPTY_ID_SET, result);
            }
            catch (Exception e) {
                EGFPatternPlugin.getDefault().logError(NLS.bind((String)EGFPatternMessages.collect_error1, (Object)uri.toString()), e);
            }
            ++n2;
        }
        return result;
    }

    public List<PatternLibrary> getAllLibraries() {
        IPlatformFcore[] platformFcores;
        ArrayList<PatternLibrary> result = new ArrayList<PatternLibrary>(200);
        IPlatformFcore[] iPlatformFcoreArray = platformFcores = EGFCorePlugin.getPlatformFcores();
        int n = platformFcores.length;
        int n2 = 0;
        while (n2 < n) {
            IPlatformFcore platformFcore = iPlatformFcoreArray[n2];
            URI uri = platformFcore.getURI();
            try {
                Resource res = this.resourceSet.getResource(uri, true);
                PatternLibraryCollector.INSTANCE.collect((List<EObject>)res.getContents(), result, (Set<String>)PatternCollector.EMPTY_ID_SET);
            }
            catch (Exception e) {
                EGFPatternPlugin.getDefault().logError(NLS.bind((String)EGFPatternMessages.collect_error2, (Object)uri.toString()), e);
            }
            ++n2;
        }
        return result;
    }

    private void collectPatterns(URI uri, Set<String> ids, List<Pattern> collector) {
        Resource res = this.resourceSet.getResource(uri, true);
        PatternCollector.INSTANCE.collect((List<EObject>)res.getContents(), collector, ids);
    }

    public static String generateID() {
        return EcoreUtil.generateUUID().replaceAll("\\W", "");
    }

    public static String uniqueName(NamedModelElement parameter) {
        return String.valueOf(parameter.getName().replaceAll("\\W", "")) + "_" + parameter.getID().replaceAll("\\W", "");
    }

    public static String localizeName(PatternParameter parameter) {
        return String.valueOf(parameter.getName()) + "Parameter";
    }

    public static List<PatternMethod> getUserMethods(Pattern pattern) {
        ArrayList<PatternMethod> result = new ArrayList<PatternMethod>();
        for (PatternMethod m : pattern.getMethods()) {
            String name = m.getName();
            if (PatternFactory.isSpecialMethod(name)) continue;
            result.add(m);
        }
        return result;
    }

    public void clear() {
        for (Resource res : this.resourceSet.getResources()) {
            res.unload();
        }
        this.resourceSet.getResources().clear();
    }

    private PatternHelper(TransactionalEditingDomain domain) {
        this(domain.getResourceSet());
    }

    private PatternHelper(ResourceSet resourceSet) {
        this.resourceSet = resourceSet;
    }

    public static final PatternHelper createCollector() {
        return new PatternHelper((ResourceSet)new EgfResourceSet());
    }
}

