/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.pattern.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.egf.common.helper.URIHelper;
import org.eclipse.egf.core.fcore.IPlatformFcore;
import org.eclipse.egf.core.platform.EGFPlatformPlugin;
import org.eclipse.egf.model.l10n.EGFModelMessages;
import org.eclipse.egf.model.pattern.Pattern;
import org.eclipse.egf.model.pattern.PatternMethod;
import org.eclipse.egf.model.pattern.template.TemplateModelFileHelper;
import org.eclipse.emf.common.util.URI;

public class TemplateFileHelper {
    private TemplateFileHelper() {
    }

    public static void setContent(IFile file, String source) throws CoreException {
        TemplateFileHelper.setContent(file, source, true);
    }

    public static void setContent(IFile file, String source, boolean keepHistory) throws CoreException {
        TemplateFileHelper.setContent(file, new ByteArrayInputStream(source.getBytes()), keepHistory);
    }

    public static void setContent(IFile file, InputStream source, boolean keepHistory) throws CoreException {
        if (file.exists()) {
            file.setContents(source, true, keepHistory, null);
        } else {
            TemplateFileHelper.createParentfolders(file.getProject(), file.getProjectRelativePath().removeLastSegments(1));
            file.create(source, true, null);
        }
    }

    public static void createParentfolders(IProject project, IPath folderPath) throws CoreException {
        if (folderPath.isEmpty()) {
            return;
        }
        IFolder folder = project.getFolder(folderPath);
        if (folder == null) {
            throw new IllegalStateException();
        }
        if (!folder.exists()) {
            TemplateFileHelper.createParentfolders(project, folderPath.removeLastSegments(1));
            folder.create(true, true, null);
        }
    }

    public static String getContent(String pluginId, IProject project, IPath templatePath) throws CoreException, IOException {
        IFile file = project.getFile(templatePath);
        if (file == null) {
            throw new IllegalStateException();
        }
        if (file.exists()) {
            return TemplateFileHelper.getFileContent(file);
        }
        URI uri = URIHelper.getPlatformPluginURI((String)pluginId, (String)templatePath.toPortableString(), (boolean)false);
        return TemplateFileHelper.getContent(EGFPlatformPlugin.getPlatformURIConverter().createInputStream(uri));
    }

    public static String getContent(PatternMethod method) throws IOException {
        if (method == null) {
            throw new IllegalArgumentException(EGFModelMessages.fileHelper_error4);
        }
        return TemplateFileHelper.getContent(TemplateModelFileHelper.getInputStream((PatternMethod)method));
    }

    public static String getFileContent(IFile file) throws CoreException, IOException {
        return TemplateFileHelper.getContent(file.getContents());
    }

    private static String getContent(InputStream contents) throws IOException {
        byte[] buf = null;
        try {
            buf = new byte[contents.available()];
            contents.read(buf);
        }
        finally {
            if (contents != null) {
                contents.close();
            }
        }
        return new String(buf);
    }

    public static void touchHeaderTemplates(IProgressMonitor monitor, IPlatformFcore fcore, List<Pattern> patterns) throws CoreException {
        if (fcore == null || patterns == null || patterns.isEmpty()) {
            return;
        }
        IProject project = fcore.getPlatformBundle().getProject();
        if (project == null) {
            return;
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(100 * patterns.size()));
        subMonitor.beginTask(null, 100 * patterns.size());
        for (Pattern pattern : patterns) {
            IResource resource = ResourcesPlugin.getWorkspace().getRoot().findMember(pattern.getHeaderMethod().getPatternFilePath().toPlatformString(true));
            if (resource != null) {
                resource.touch((IProgressMonitor)subMonitor.newChild(100, 0));
            }
            subMonitor.worked(100);
        }
    }
}

