/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.core.epackage;

import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.core.epackage.IProxyEObject;
import org.eclipse.egf.core.epackage.IProxyEPackage;
import org.eclipse.egf.core.epackage.IProxyERoot;
import org.eclipse.egf.core.genmodel.IPlatformGenModel;
import org.eclipse.emf.common.util.URI;

public class ProxyTargetPlatformFactory {
    protected static URI getEPackageNsURI(URI uri) {
        if (uri == null) {
            return null;
        }
        String innerUri = uri.toString();
        if (!innerUri.contains("#//")) {
            return uri;
        }
        return URI.createURI((String)innerUri.substring(0, innerUri.indexOf("#//")));
    }

    public IProxyEObject getIProxyEObject(URI uri) {
        IProxyERoot proxy = this.getIProxyERoot(uri);
        if (proxy != null) {
            return proxy.getIProxyEObject(uri);
        }
        return null;
    }

    public IProxyEPackage getIProxyEPackage(URI uri) {
        IProxyERoot proxy = this.getIProxyERoot(uri);
        if (proxy != null && proxy.getChildren().length == 1) {
            return proxy.getChildren()[0];
        }
        return null;
    }

    public IProxyERoot getIProxyERoot(URI uri) {
        if (uri == null) {
            return null;
        }
        URI nsURI = ProxyTargetPlatformFactory.getEPackageNsURI(uri);
        IPlatformGenModel packageGenModel = EGFCorePlugin.getRuntimePlatformGenModel(nsURI);
        if (packageGenModel == null) {
            return null;
        }
        URI innerNsURI = packageGenModel.getEPackageNsURI(uri);
        if (innerNsURI != null) {
            packageGenModel = EGFCorePlugin.getRuntimePlatformGenModel(innerNsURI);
        }
        if (packageGenModel == null) {
            return null;
        }
        return packageGenModel.getIProxyERoot();
    }
}

